/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFOplinkPortPowerSet;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOplinkPortPowerSetVer13
implements OFOplinkPortPowerSet {
    private static final Logger logger = LoggerFactory.getLogger(OFOplinkPortPowerSetVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 20;
    private static final long DEFAULT_XID = 0L;
    private static final int DEFAULT_PORT = 0;
    private static final int DEFAULT_POWER_VALUE = 0;
    private final long xid;
    private final int port;
    private final int powerValue;
    static final OFOplinkPortPowerSetVer13 DEFAULT = new OFOplinkPortPowerSetVer13(0L, 0, 0);
    static final Reader READER = new Reader();
    static final OFOplinkPortPowerSetVer13Funnel FUNNEL = new OFOplinkPortPowerSetVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOplinkPortPowerSetVer13(long xid, int port, int powerValue) {
        this.xid = xid;
        this.port = port;
        this.powerValue = powerValue;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 0xFF000088L;
    }

    @Override
    public long getExpType() {
        return 10L;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getPowerValue() {
        return this.powerValue;
    }

    @Override
    public OFOplinkPortPowerSet.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOplinkPortPowerSetVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("port=").append(this.port);
        b.append(", ");
        b.append("powerValue=").append(this.powerValue);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOplinkPortPowerSetVer13 other = (OFOplinkPortPowerSetVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return this.powerValue == other.powerValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + this.port;
        result = 31 * result + this.powerValue;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOplinkPortPowerSetVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOplinkPortPowerSetVer13 message) {
            bb.writeByte(4);
            bb.writeByte(4);
            bb.writeShort(20);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(-16777080);
            bb.writeInt(10);
            bb.writeShort((int)U16.t(message.port));
            bb.writeShort((int)U16.t(message.powerValue));
        }
    }

    static class OFOplinkPortPowerSetVer13Funnel
    implements Funnel<OFOplinkPortPowerSetVer13> {
        private static final long serialVersionUID = 1L;

        OFOplinkPortPowerSetVer13Funnel() {
        }

        public void funnel(OFOplinkPortPowerSetVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putShort((short)20);
            sink.putLong(message.xid);
            sink.putInt(-16777080);
            sink.putInt(10);
            sink.putInt(message.port);
            sink.putInt(message.powerValue);
        }
    }

    static class Reader
    implements OFMessageReader<OFOplinkPortPowerSet> {
        Reader() {
        }

        @Override
        public OFOplinkPortPowerSet readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != -16777080) {
                throw new OFParseError("Wrong experimenter: Expected=0xff000088L(0xff000088L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 10) {
                throw new OFParseError("Wrong expType: Expected=0xaL(0xaL), got=" + expType);
            }
            int port = U16.f(bb.readShort());
            int powerValue = U16.f(bb.readShort());
            OFOplinkPortPowerSetVer13 oplinkPortPowerSetVer13 = new OFOplinkPortPowerSetVer13(xid, port, powerValue);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oplinkPortPowerSetVer13);
            }
            return oplinkPortPowerSetVer13;
        }
    }

    static class Builder
    implements OFOplinkPortPowerSet.Builder {
        private boolean xidSet;
        private long xid;
        private boolean portSet;
        private int port;
        private boolean powerValueSet;
        private int powerValue;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFOplinkPortPowerSet.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 0xFF000088L;
        }

        @Override
        public long getExpType() {
            return 10L;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public OFOplinkPortPowerSet.Builder setPort(int port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public int getPowerValue() {
            return this.powerValue;
        }

        @Override
        public OFOplinkPortPowerSet.Builder setPowerValue(int powerValue) {
            this.powerValue = powerValue;
            this.powerValueSet = true;
            return this;
        }

        @Override
        public OFOplinkPortPowerSet build() {
            long xid = this.xidSet ? this.xid : 0L;
            int port = this.portSet ? this.port : 0;
            int powerValue = this.powerValueSet ? this.powerValue : 0;
            return new OFOplinkPortPowerSetVer13(xid, port, powerValue);
        }
    }

    static class BuilderWithParent
    implements OFOplinkPortPowerSet.Builder {
        final OFOplinkPortPowerSetVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean portSet;
        private int port;
        private boolean powerValueSet;
        private int powerValue;

        BuilderWithParent(OFOplinkPortPowerSetVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFOplinkPortPowerSet.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 0xFF000088L;
        }

        @Override
        public long getExpType() {
            return 10L;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public OFOplinkPortPowerSet.Builder setPort(int port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public int getPowerValue() {
            return this.powerValue;
        }

        @Override
        public OFOplinkPortPowerSet.Builder setPowerValue(int powerValue) {
            this.powerValue = powerValue;
            this.powerValueSet = true;
            return this;
        }

        @Override
        public OFOplinkPortPowerSet build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            int port = this.portSet ? this.port : this.parentMessage.port;
            int powerValue = this.powerValueSet ? this.powerValue : this.parentMessage.powerValue;
            return new OFOplinkPortPowerSetVer13(xid, port, powerValue);
        }
    }
}

