/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFGroupDescStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsRequestFlagsSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGroupDescStatsRequestVer13
implements OFGroupDescStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFGroupDescStatsRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    static final OFGroupDescStatsRequestVer13 DEFAULT = new OFGroupDescStatsRequestVer13(0L, DEFAULT_FLAGS);
    static final Reader READER = new Reader();
    static final OFGroupDescStatsRequestVer13Funnel FUNNEL = new OFGroupDescStatsRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFGroupDescStatsRequestVer13(long xid, Set<OFStatsRequestFlags> flags) {
        if (flags == null) {
            throw new NullPointerException("OFGroupDescStatsRequestVer13: property flags cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.GROUP_DESC;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public OFGroupDescStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGroupDescStatsRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupDescStatsRequestVer13 other = (OFGroupDescStatsRequestVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGroupDescStatsRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFGroupDescStatsRequestVer13 message) {
            bb.writeByte(4);
            bb.writeByte(18);
            bb.writeShort(16);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(7);
            OFStatsRequestFlagsSerializerVer13.writeTo(bb, message.flags);
            bb.writeZero(4);
        }
    }

    static class OFGroupDescStatsRequestVer13Funnel
    implements Funnel<OFGroupDescStatsRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFGroupDescStatsRequestVer13Funnel() {
        }

        public void funnel(OFGroupDescStatsRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)18);
            sink.putShort((short)16);
            sink.putLong(message.xid);
            sink.putShort((short)7);
            OFStatsRequestFlagsSerializerVer13.putTo(message.flags, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFGroupDescStatsRequest> {
        Reader() {
        }

        @Override
        public OFGroupDescStatsRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 7) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.GROUP_DESC(7), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            OFGroupDescStatsRequestVer13 groupDescStatsRequestVer13 = new OFGroupDescStatsRequestVer13(xid, flags);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)groupDescStatsRequestVer13);
            }
            return groupDescStatsRequestVer13;
        }
    }

    static class Builder
    implements OFGroupDescStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGroupDescStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.GROUP_DESC;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFGroupDescStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFGroupDescStatsRequest build() {
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFGroupDescStatsRequestVer13(xid, flags);
        }
    }

    static class BuilderWithParent
    implements OFGroupDescStatsRequest.Builder {
        final OFGroupDescStatsRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;

        BuilderWithParent(OFGroupDescStatsRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGroupDescStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.GROUP_DESC;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFGroupDescStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFGroupDescStatsRequest build() {
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFGroupDescStatsRequestVer13(xid, flags);
        }
    }
}

