/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFExpPortAdjacency;
import org.projectfloodlight.openflow.protocol.OFExpPortAdjacencyReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFExpPortAdjacencyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsReplyFlagsSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFExpPortAdjacencyReplyVer13
implements OFExpPortAdjacencyReply {
    private static final Logger logger = LoggerFactory.getLogger(OFExpPortAdjacencyReplyVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final List<OFExpPortAdjacency> DEFAULT_ENTRIES = ImmutableList.of();
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final List<OFExpPortAdjacency> entries;
    static final OFExpPortAdjacencyReplyVer13 DEFAULT = new OFExpPortAdjacencyReplyVer13(0L, DEFAULT_FLAGS, DEFAULT_ENTRIES);
    static final Reader READER = new Reader();
    static final OFExpPortAdjacencyReplyVer13Funnel FUNNEL = new OFExpPortAdjacencyReplyVer13Funnel();
    static final Writer WRITER = new Writer();

    OFExpPortAdjacencyReplyVer13(long xid, Set<OFStatsReplyFlags> flags, List<OFExpPortAdjacency> entries) {
        if (flags == null) {
            throw new NullPointerException("OFExpPortAdjacencyReplyVer13: property flags cannot be null");
        }
        if (entries == null) {
            throw new NullPointerException("OFExpPortAdjacencyReplyVer13: property entries cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.entries = entries;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getExperimenter() {
        return 0xFF000007L;
    }

    @Override
    public long getSubtype() {
        return 2L;
    }

    @Override
    public List<OFExpPortAdjacency> getEntries() {
        return this.entries;
    }

    @Override
    public OFExpPortAdjacencyReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFExpPortAdjacencyReplyVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("entries=").append(this.entries);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFExpPortAdjacencyReplyVer13 other = (OFExpPortAdjacencyReplyVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFExpPortAdjacencyReplyVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFExpPortAdjacencyReplyVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(19);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            OFStatsReplyFlagsSerializerVer13.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(-16777209);
            bb.writeInt(2);
            ChannelUtils.writeList(bb, message.entries);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFExpPortAdjacencyReplyVer13Funnel
    implements Funnel<OFExpPortAdjacencyReplyVer13> {
        private static final long serialVersionUID = 1L;

        OFExpPortAdjacencyReplyVer13Funnel() {
        }

        public void funnel(OFExpPortAdjacencyReplyVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)19);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            OFStatsReplyFlagsSerializerVer13.putTo(message.flags, sink);
            sink.putInt(-16777209);
            sink.putInt(2);
            FunnelUtils.putList(message.entries, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFExpPortAdjacencyReply> {
        Reader() {
        }

        @Override
        public OFExpPortAdjacencyReply readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != -16777209) {
                throw new OFParseError("Wrong experimenter: Expected=0xff000007L(0xff000007L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 2) {
                throw new OFParseError("Wrong subtype: Expected=0x2L(0x2L), got=" + subtype);
            }
            List<OFExpPortAdjacency> entries = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFExpPortAdjacencyVer13.READER);
            OFExpPortAdjacencyReplyVer13 expPortAdjacencyReplyVer13 = new OFExpPortAdjacencyReplyVer13(xid, flags, entries);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)expPortAdjacencyReplyVer13);
            }
            return expPortAdjacencyReplyVer13;
        }
    }

    static class Builder
    implements OFExpPortAdjacencyReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean entriesSet;
        private List<OFExpPortAdjacency> entries;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFExpPortAdjacencyReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFExpPortAdjacencyReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 0xFF000007L;
        }

        @Override
        public long getSubtype() {
            return 2L;
        }

        @Override
        public List<OFExpPortAdjacency> getEntries() {
            return this.entries;
        }

        @Override
        public OFExpPortAdjacencyReply.Builder setEntries(List<OFExpPortAdjacency> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFExpPortAdjacencyReply build() {
            List<OFExpPortAdjacency> entries;
            Set<OFStatsReplyFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsReplyFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List<OFExpPortAdjacency> list = entries = this.entriesSet ? this.entries : DEFAULT_ENTRIES;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFExpPortAdjacencyReplyVer13(xid, flags, entries);
        }
    }

    static class BuilderWithParent
    implements OFExpPortAdjacencyReply.Builder {
        final OFExpPortAdjacencyReplyVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean entriesSet;
        private List<OFExpPortAdjacency> entries;

        BuilderWithParent(OFExpPortAdjacencyReplyVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFExpPortAdjacencyReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFExpPortAdjacencyReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 0xFF000007L;
        }

        @Override
        public long getSubtype() {
            return 2L;
        }

        @Override
        public List<OFExpPortAdjacency> getEntries() {
            return this.entries;
        }

        @Override
        public OFExpPortAdjacencyReply.Builder setEntries(List<OFExpPortAdjacency> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFExpPortAdjacencyReply build() {
            List entries;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List list = entries = this.entriesSet ? this.entries : this.parentMessage.entries;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFExpPortAdjacencyReplyVer13(xid, flags, entries);
        }
    }
}

