/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFExpExtAdId;
import org.projectfloodlight.openflow.protocol.OFExpPortAdjacencyId;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFExpExtAdIdVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFExpPortAdjacencyIdVer13
implements OFExpPortAdjacencyId {
    private static final Logger logger = LoggerFactory.getLogger(OFExpPortAdjacencyIdVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 4;
    private static final List<OFExpExtAdId> DEFAULT_AD_ID = ImmutableList.of();
    private final List<OFExpExtAdId> adId;
    static final OFExpPortAdjacencyIdVer13 DEFAULT = new OFExpPortAdjacencyIdVer13(DEFAULT_AD_ID);
    static final Reader READER = new Reader();
    static final OFExpPortAdjacencyIdVer13Funnel FUNNEL = new OFExpPortAdjacencyIdVer13Funnel();
    static final Writer WRITER = new Writer();

    OFExpPortAdjacencyIdVer13(List<OFExpExtAdId> adId) {
        if (adId == null) {
            throw new NullPointerException("OFExpPortAdjacencyIdVer13: property adId cannot be null");
        }
        this.adId = adId;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public List<OFExpExtAdId> getAdId() {
        return this.adId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFExpPortAdjacencyId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFExpPortAdjacencyIdVer13(");
        b.append("adId=").append(this.adId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFExpPortAdjacencyIdVer13 other = (OFExpPortAdjacencyIdVer13)obj;
        return !(this.adId == null ? other.adId != null : !this.adId.equals(other.adId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adId == null ? 0 : this.adId.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFExpPortAdjacencyIdVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFExpPortAdjacencyIdVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(3);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.adId);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFExpPortAdjacencyIdVer13Funnel
    implements Funnel<OFExpPortAdjacencyIdVer13> {
        private static final long serialVersionUID = 1L;

        OFExpPortAdjacencyIdVer13Funnel() {
        }

        public void funnel(OFExpPortAdjacencyIdVer13 message, PrimitiveSink sink) {
            sink.putShort((short)3);
            FunnelUtils.putList(message.adId, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFExpPortAdjacencyId> {
        Reader() {
        }

        @Override
        public OFExpPortAdjacencyId readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 3) {
                throw new OFParseError("Wrong type: Expected=0x3(0x3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<OFExpExtAdId> adId = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFExpExtAdIdVer13.READER);
            OFExpPortAdjacencyIdVer13 expPortAdjacencyIdVer13 = new OFExpPortAdjacencyIdVer13(adId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)expPortAdjacencyIdVer13);
            }
            return expPortAdjacencyIdVer13;
        }
    }

    static class Builder
    implements OFExpPortAdjacencyId.Builder {
        private boolean adIdSet;
        private List<OFExpExtAdId> adId;

        Builder() {
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public List<OFExpExtAdId> getAdId() {
            return this.adId;
        }

        @Override
        public OFExpPortAdjacencyId.Builder setAdId(List<OFExpExtAdId> adId) {
            this.adId = adId;
            this.adIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFExpPortAdjacencyId build() {
            List<OFExpExtAdId> adId;
            List<OFExpExtAdId> list = adId = this.adIdSet ? this.adId : DEFAULT_AD_ID;
            if (adId == null) {
                throw new NullPointerException("Property adId must not be null");
            }
            return new OFExpPortAdjacencyIdVer13(adId);
        }
    }

    static class BuilderWithParent
    implements OFExpPortAdjacencyId.Builder {
        final OFExpPortAdjacencyIdVer13 parentMessage;
        private boolean adIdSet;
        private List<OFExpExtAdId> adId;

        BuilderWithParent(OFExpPortAdjacencyIdVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public List<OFExpExtAdId> getAdId() {
            return this.adId;
        }

        @Override
        public OFExpPortAdjacencyId.Builder setAdId(List<OFExpExtAdId> adId) {
            this.adId = adId;
            this.adIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFExpPortAdjacencyId build() {
            List adId;
            List list = adId = this.adIdSet ? this.adId : this.parentMessage.adId;
            if (adId == null) {
                throw new NullPointerException("Property adId must not be null");
            }
            return new OFExpPortAdjacencyIdVer13(adId);
        }
    }
}

