/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFExpPortAdidOtn;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFBitMask128;
import org.projectfloodlight.openflow.types.OFBitMask256;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFExpPortAdidOtnVer13
implements OFExpPortAdidOtn {
    private static final Logger logger = LoggerFactory.getLogger(OFExpPortAdidOtnVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 72;
    private static final int DEFAULT_TYPE = 0;
    private static final OFBitMask128 DEFAULT_SAPI = OFBitMask128.NONE;
    private static final OFBitMask128 DEFAULT_DAPI = OFBitMask128.NONE;
    private static final OFBitMask256 DEFAULT_OPSPEC = OFBitMask256.NONE;
    private final int type;
    private final OFBitMask128 sapi;
    private final OFBitMask128 dapi;
    private final OFBitMask256 opspec;
    static final OFExpPortAdidOtnVer13 DEFAULT = new OFExpPortAdidOtnVer13(0, DEFAULT_SAPI, DEFAULT_DAPI, DEFAULT_OPSPEC);
    static final Reader READER = new Reader();
    static final OFExpPortAdidOtnVer13Funnel FUNNEL = new OFExpPortAdidOtnVer13Funnel();
    static final Writer WRITER = new Writer();

    OFExpPortAdidOtnVer13(int type, OFBitMask128 sapi, OFBitMask128 dapi, OFBitMask256 opspec) {
        if (sapi == null) {
            throw new NullPointerException("OFExpPortAdidOtnVer13: property sapi cannot be null");
        }
        if (dapi == null) {
            throw new NullPointerException("OFExpPortAdidOtnVer13: property dapi cannot be null");
        }
        if (opspec == null) {
            throw new NullPointerException("OFExpPortAdidOtnVer13: property opspec cannot be null");
        }
        this.type = type;
        this.sapi = sapi;
        this.dapi = dapi;
        this.opspec = opspec;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getNamespace() {
        return 0;
    }

    @Override
    public int getNsType() {
        return 0;
    }

    @Override
    public OFBitMask128 getSapi() {
        return this.sapi;
    }

    @Override
    public OFBitMask128 getDapi() {
        return this.dapi;
    }

    @Override
    public OFBitMask256 getOpspec() {
        return this.opspec;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFExpPortAdidOtn.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFExpPortAdidOtnVer13(");
        b.append("type=").append(this.type);
        b.append(", ");
        b.append("sapi=").append(this.sapi);
        b.append(", ");
        b.append("dapi=").append(this.dapi);
        b.append(", ");
        b.append("opspec=").append(this.opspec);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFExpPortAdidOtnVer13 other = (OFExpPortAdidOtnVer13)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.sapi == null ? other.sapi != null : !this.sapi.equals(other.sapi)) {
            return false;
        }
        if (this.dapi == null ? other.dapi != null : !this.dapi.equals(other.dapi)) {
            return false;
        }
        return !(this.opspec == null ? other.opspec != null : !this.opspec.equals(other.opspec));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type;
        result = 31 * result + (this.sapi == null ? 0 : this.sapi.hashCode());
        result = 31 * result + (this.dapi == null ? 0 : this.dapi.hashCode());
        result = 31 * result + (this.opspec == null ? 0 : this.opspec.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFExpPortAdidOtnVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFExpPortAdidOtnVer13 message) {
            bb.writeShort((int)U16.t(message.type));
            bb.writeShort(72);
            bb.writeShort(0);
            bb.writeShort(0);
            message.sapi.write16Bytes(bb);
            message.dapi.write16Bytes(bb);
            message.opspec.write32Bytes(bb);
        }
    }

    static class OFExpPortAdidOtnVer13Funnel
    implements Funnel<OFExpPortAdidOtnVer13> {
        private static final long serialVersionUID = 1L;

        OFExpPortAdidOtnVer13Funnel() {
        }

        public void funnel(OFExpPortAdidOtnVer13 message, PrimitiveSink sink) {
            sink.putInt(message.type);
            sink.putShort((short)72);
            sink.putShort((short)0);
            sink.putShort((short)0);
            message.sapi.putTo(sink);
            message.dapi.putTo(sink);
            message.opspec.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFExpPortAdidOtn> {
        Reader() {
        }

        @Override
        public OFExpPortAdidOtn readFrom(ChannelBuffer bb) throws OFParseError {
            short namespace;
            int start = bb.readerIndex();
            int type = U16.f(bb.readShort());
            int length = U16.f(bb.readShort());
            if (length != 72) {
                throw new OFParseError("Wrong length: Expected=72(72), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((namespace = bb.readShort()) != 0) {
                throw new OFParseError("Wrong namespace: Expected=0x0(0x0), got=" + namespace);
            }
            short nsType = bb.readShort();
            if (nsType != 0) {
                throw new OFParseError("Wrong nsType: Expected=0x0(0x0), got=" + nsType);
            }
            OFBitMask128 sapi = OFBitMask128.read16Bytes(bb);
            OFBitMask128 dapi = OFBitMask128.read16Bytes(bb);
            OFBitMask256 opspec = OFBitMask256.read32Bytes(bb);
            OFExpPortAdidOtnVer13 expPortAdidOtnVer13 = new OFExpPortAdidOtnVer13(type, sapi, dapi, opspec);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)expPortAdidOtnVer13);
            }
            return expPortAdidOtnVer13;
        }
    }

    static class Builder
    implements OFExpPortAdidOtn.Builder {
        private boolean typeSet;
        private int type;
        private boolean sapiSet;
        private OFBitMask128 sapi;
        private boolean dapiSet;
        private OFBitMask128 dapi;
        private boolean opspecSet;
        private OFBitMask256 opspec;

        Builder() {
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public OFExpPortAdidOtn.Builder setType(int type) {
            this.type = type;
            this.typeSet = true;
            return this;
        }

        @Override
        public int getNamespace() {
            return 0;
        }

        @Override
        public int getNsType() {
            return 0;
        }

        @Override
        public OFBitMask128 getSapi() {
            return this.sapi;
        }

        @Override
        public OFExpPortAdidOtn.Builder setSapi(OFBitMask128 sapi) {
            this.sapi = sapi;
            this.sapiSet = true;
            return this;
        }

        @Override
        public OFBitMask128 getDapi() {
            return this.dapi;
        }

        @Override
        public OFExpPortAdidOtn.Builder setDapi(OFBitMask128 dapi) {
            this.dapi = dapi;
            this.dapiSet = true;
            return this;
        }

        @Override
        public OFBitMask256 getOpspec() {
            return this.opspec;
        }

        @Override
        public OFExpPortAdidOtn.Builder setOpspec(OFBitMask256 opspec) {
            this.opspec = opspec;
            this.opspecSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFExpPortAdidOtn build() {
            OFBitMask256 opspec;
            OFBitMask128 dapi;
            OFBitMask128 sapi;
            int type = this.typeSet ? this.type : 0;
            OFBitMask128 oFBitMask128 = sapi = this.sapiSet ? this.sapi : DEFAULT_SAPI;
            if (sapi == null) {
                throw new NullPointerException("Property sapi must not be null");
            }
            OFBitMask128 oFBitMask1282 = dapi = this.dapiSet ? this.dapi : DEFAULT_DAPI;
            if (dapi == null) {
                throw new NullPointerException("Property dapi must not be null");
            }
            OFBitMask256 oFBitMask256 = opspec = this.opspecSet ? this.opspec : DEFAULT_OPSPEC;
            if (opspec == null) {
                throw new NullPointerException("Property opspec must not be null");
            }
            return new OFExpPortAdidOtnVer13(type, sapi, dapi, opspec);
        }
    }

    static class BuilderWithParent
    implements OFExpPortAdidOtn.Builder {
        final OFExpPortAdidOtnVer13 parentMessage;
        private boolean typeSet;
        private int type;
        private boolean sapiSet;
        private OFBitMask128 sapi;
        private boolean dapiSet;
        private OFBitMask128 dapi;
        private boolean opspecSet;
        private OFBitMask256 opspec;

        BuilderWithParent(OFExpPortAdidOtnVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public OFExpPortAdidOtn.Builder setType(int type) {
            this.type = type;
            this.typeSet = true;
            return this;
        }

        @Override
        public int getNamespace() {
            return 0;
        }

        @Override
        public int getNsType() {
            return 0;
        }

        @Override
        public OFBitMask128 getSapi() {
            return this.sapi;
        }

        @Override
        public OFExpPortAdidOtn.Builder setSapi(OFBitMask128 sapi) {
            this.sapi = sapi;
            this.sapiSet = true;
            return this;
        }

        @Override
        public OFBitMask128 getDapi() {
            return this.dapi;
        }

        @Override
        public OFExpPortAdidOtn.Builder setDapi(OFBitMask128 dapi) {
            this.dapi = dapi;
            this.dapiSet = true;
            return this;
        }

        @Override
        public OFBitMask256 getOpspec() {
            return this.opspec;
        }

        @Override
        public OFExpPortAdidOtn.Builder setOpspec(OFBitMask256 opspec) {
            this.opspec = opspec;
            this.opspecSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFExpPortAdidOtn build() {
            OFBitMask256 opspec;
            OFBitMask128 dapi;
            OFBitMask128 sapi;
            int type = this.typeSet ? this.type : this.parentMessage.type;
            OFBitMask128 oFBitMask128 = sapi = this.sapiSet ? this.sapi : this.parentMessage.sapi;
            if (sapi == null) {
                throw new NullPointerException("Property sapi must not be null");
            }
            OFBitMask128 oFBitMask1282 = dapi = this.dapiSet ? this.dapi : this.parentMessage.dapi;
            if (dapi == null) {
                throw new NullPointerException("Property dapi must not be null");
            }
            OFBitMask256 oFBitMask256 = opspec = this.opspecSet ? this.opspec : this.parentMessage.opspec;
            if (opspec == null) {
                throw new NullPointerException("Property opspec must not be null");
            }
            return new OFExpPortAdidOtnVer13(type, sapi, dapi, opspec);
        }
    }
}

