/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFExpExtAdidSonet;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFBitMask128;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFExpExtAdidSonetVer13
implements OFExpExtAdidSonet {
    private static final Logger logger = LoggerFactory.getLogger(OFExpExtAdidSonetVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 24;
    private static final int DEFAULT_TYPE = 0;
    private static final OFBitMask128 DEFAULT_ID = OFBitMask128.NONE;
    private final int type;
    private final OFBitMask128 id;
    static final OFExpExtAdidSonetVer13 DEFAULT = new OFExpExtAdidSonetVer13(0, DEFAULT_ID);
    static final Reader READER = new Reader();
    static final OFExpExtAdidSonetVer13Funnel FUNNEL = new OFExpExtAdidSonetVer13Funnel();
    static final Writer WRITER = new Writer();

    OFExpExtAdidSonetVer13(int type, OFBitMask128 id) {
        if (id == null) {
            throw new NullPointerException("OFExpExtAdidSonetVer13: property id cannot be null");
        }
        this.type = type;
        this.id = id;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getNamespace() {
        return 0;
    }

    @Override
    public int getNsType() {
        return 1;
    }

    @Override
    public OFBitMask128 getId() {
        return this.id;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFExpExtAdidSonet.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFExpExtAdidSonetVer13(");
        b.append("type=").append(this.type);
        b.append(", ");
        b.append("id=").append(this.id);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFExpExtAdidSonetVer13 other = (OFExpExtAdidSonetVer13)obj;
        if (this.type != other.type) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFExpExtAdidSonetVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFExpExtAdidSonetVer13 message) {
            bb.writeShort((int)U16.t(message.type));
            bb.writeShort(24);
            bb.writeShort(0);
            bb.writeShort(1);
            message.id.write16Bytes(bb);
        }
    }

    static class OFExpExtAdidSonetVer13Funnel
    implements Funnel<OFExpExtAdidSonetVer13> {
        private static final long serialVersionUID = 1L;

        OFExpExtAdidSonetVer13Funnel() {
        }

        public void funnel(OFExpExtAdidSonetVer13 message, PrimitiveSink sink) {
            sink.putInt(message.type);
            sink.putShort((short)24);
            sink.putShort((short)0);
            sink.putShort((short)1);
            message.id.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFExpExtAdidSonet> {
        Reader() {
        }

        @Override
        public OFExpExtAdidSonet readFrom(ChannelBuffer bb) throws OFParseError {
            short namespace;
            int start = bb.readerIndex();
            int type = U16.f(bb.readShort());
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((namespace = bb.readShort()) != 0) {
                throw new OFParseError("Wrong namespace: Expected=0x0(0x0), got=" + namespace);
            }
            short nsType = bb.readShort();
            if (nsType != 1) {
                throw new OFParseError("Wrong nsType: Expected=0x1(0x1), got=" + nsType);
            }
            OFBitMask128 id = OFBitMask128.read16Bytes(bb);
            OFExpExtAdidSonetVer13 expExtAdidSonetVer13 = new OFExpExtAdidSonetVer13(type, id);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)expExtAdidSonetVer13);
            }
            return expExtAdidSonetVer13;
        }
    }

    static class Builder
    implements OFExpExtAdidSonet.Builder {
        private boolean typeSet;
        private int type;
        private boolean idSet;
        private OFBitMask128 id;

        Builder() {
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public OFExpExtAdidSonet.Builder setType(int type) {
            this.type = type;
            this.typeSet = true;
            return this;
        }

        @Override
        public int getNamespace() {
            return 0;
        }

        @Override
        public int getNsType() {
            return 1;
        }

        @Override
        public OFBitMask128 getId() {
            return this.id;
        }

        @Override
        public OFExpExtAdidSonet.Builder setId(OFBitMask128 id) {
            this.id = id;
            this.idSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFExpExtAdidSonet build() {
            OFBitMask128 id;
            int type = this.typeSet ? this.type : 0;
            OFBitMask128 oFBitMask128 = id = this.idSet ? this.id : DEFAULT_ID;
            if (id == null) {
                throw new NullPointerException("Property id must not be null");
            }
            return new OFExpExtAdidSonetVer13(type, id);
        }
    }

    static class BuilderWithParent
    implements OFExpExtAdidSonet.Builder {
        final OFExpExtAdidSonetVer13 parentMessage;
        private boolean typeSet;
        private int type;
        private boolean idSet;
        private OFBitMask128 id;

        BuilderWithParent(OFExpExtAdidSonetVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public OFExpExtAdidSonet.Builder setType(int type) {
            this.type = type;
            this.typeSet = true;
            return this;
        }

        @Override
        public int getNamespace() {
            return 0;
        }

        @Override
        public int getNsType() {
            return 1;
        }

        @Override
        public OFBitMask128 getId() {
            return this.id;
        }

        @Override
        public OFExpExtAdidSonet.Builder setId(OFBitMask128 id) {
            this.id = id;
            this.idSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFExpExtAdidSonet build() {
            OFBitMask128 id;
            int type = this.typeSet ? this.type : this.parentMessage.type;
            OFBitMask128 oFBitMask128 = id = this.idSet ? this.id : this.parentMessage.id;
            if (id == null) {
                throw new NullPointerException("Property id must not be null");
            }
            return new OFExpExtAdidSonetVer13(type, id);
        }
    }
}

