/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFCircuitPortStatus;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortReason;
import org.projectfloodlight.openflow.protocol.OFPortState;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFPortConfigSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortReasonSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortStateSerializerVer13;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFCircuitPortStatusVer13
implements OFCircuitPortStatus {
    private static final Logger logger = LoggerFactory.getLogger(OFCircuitPortStatusVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 72;
    private static final long DEFAULT_XID = 0L;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final int DEFAULT_LENGTHS = 0;
    private static final MacAddress DEFAULT_HW_ADDR = MacAddress.NONE;
    private static final String DEFAULT_NAME = "";
    private static final Set<OFPortConfig> DEFAULT_CONFIG = ImmutableSet.of();
    private static final Set<OFPortState> DEFAULT_STATE = ImmutableSet.of();
    private static final U64 DEFAULT_IGNORE = U64.ZERO;
    private final long xid;
    private final OFPortReason reason;
    private final OFPort portNo;
    private final int lengths;
    private final MacAddress hwAddr;
    private final String name;
    private final Set<OFPortConfig> config;
    private final Set<OFPortState> state;
    private final U64 ignore;
    static final Reader READER = new Reader();
    static final OFCircuitPortStatusVer13Funnel FUNNEL = new OFCircuitPortStatusVer13Funnel();
    static final Writer WRITER = new Writer();

    OFCircuitPortStatusVer13(long xid, OFPortReason reason, OFPort portNo, int lengths, MacAddress hwAddr, String name, Set<OFPortConfig> config, Set<OFPortState> state, U64 ignore) {
        if (reason == null) {
            throw new NullPointerException("OFCircuitPortStatusVer13: property reason cannot be null");
        }
        if (portNo == null) {
            throw new NullPointerException("OFCircuitPortStatusVer13: property portNo cannot be null");
        }
        if (hwAddr == null) {
            throw new NullPointerException("OFCircuitPortStatusVer13: property hwAddr cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("OFCircuitPortStatusVer13: property name cannot be null");
        }
        if (config == null) {
            throw new NullPointerException("OFCircuitPortStatusVer13: property config cannot be null");
        }
        if (state == null) {
            throw new NullPointerException("OFCircuitPortStatusVer13: property state cannot be null");
        }
        if (ignore == null) {
            throw new NullPointerException("OFCircuitPortStatusVer13: property ignore cannot be null");
        }
        this.xid = xid;
        this.reason = reason;
        this.portNo = portNo;
        this.lengths = lengths;
        this.hwAddr = hwAddr;
        this.name = name;
        this.config = config;
        this.state = state;
        this.ignore = ignore;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 7636849L;
    }

    @Override
    public long getExpType() {
        return 12L;
    }

    @Override
    public OFPortReason getReason() {
        return this.reason;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public int getLengths() {
        return this.lengths;
    }

    @Override
    public MacAddress getHwAddr() {
        return this.hwAddr;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<OFPortConfig> getConfig() {
        return this.config;
    }

    @Override
    public Set<OFPortState> getState() {
        return this.state;
    }

    @Override
    public U64 getIgnore() {
        return this.ignore;
    }

    @Override
    public OFCircuitPortStatus.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFCircuitPortStatusVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("reason=").append((Object)this.reason);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("lengths=").append(this.lengths);
        b.append(", ");
        b.append("hwAddr=").append(this.hwAddr);
        b.append(", ");
        b.append("name=").append(this.name);
        b.append(", ");
        b.append("config=").append(this.config);
        b.append(", ");
        b.append("state=").append(this.state);
        b.append(", ");
        b.append("ignore=").append(this.ignore);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFCircuitPortStatusVer13 other = (OFCircuitPortStatusVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.lengths != other.lengths) {
            return false;
        }
        if (this.hwAddr == null ? other.hwAddr != null : !this.hwAddr.equals(other.hwAddr)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        return !(this.ignore == null ? other.ignore != null : !this.ignore.equals(other.ignore));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + this.lengths;
        result = 31 * result + (this.hwAddr == null ? 0 : this.hwAddr.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.ignore == null ? 0 : this.ignore.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFCircuitPortStatusVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFCircuitPortStatusVer13 message) {
            bb.writeByte(4);
            bb.writeByte(4);
            bb.writeShort(72);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(7636849);
            bb.writeInt(12);
            OFPortReasonSerializerVer13.writeTo(bb, message.reason);
            bb.writeZero(7);
            message.portNo.write4Bytes(bb);
            bb.writeShort((int)U16.t(message.lengths));
            bb.writeZero(2);
            message.hwAddr.write6Bytes(bb);
            bb.writeZero(2);
            ChannelUtils.writeFixedLengthString(bb, message.name, 16);
            OFPortConfigSerializerVer13.writeTo(bb, message.config);
            OFPortStateSerializerVer13.writeTo(bb, message.state);
            bb.writeLong(message.ignore.getValue());
        }
    }

    static class OFCircuitPortStatusVer13Funnel
    implements Funnel<OFCircuitPortStatusVer13> {
        private static final long serialVersionUID = 1L;

        OFCircuitPortStatusVer13Funnel() {
        }

        public void funnel(OFCircuitPortStatusVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putShort((short)72);
            sink.putLong(message.xid);
            sink.putInt(7636849);
            sink.putInt(12);
            OFPortReasonSerializerVer13.putTo(message.reason, sink);
            message.portNo.putTo(sink);
            sink.putInt(message.lengths);
            message.hwAddr.putTo(sink);
            sink.putUnencodedChars((CharSequence)message.name);
            OFPortConfigSerializerVer13.putTo(message.config, sink);
            OFPortStateSerializerVer13.putTo(message.state, sink);
            message.ignore.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFCircuitPortStatus> {
        Reader() {
        }

        @Override
        public OFCircuitPortStatus readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 72) {
                throw new OFParseError("Wrong length: Expected=72(72), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 7636849) {
                throw new OFParseError("Wrong experimenter: Expected=0x748771L(0x748771L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 12) {
                throw new OFParseError("Wrong expType: Expected=0xcL(0xcL), got=" + expType);
            }
            OFPortReason reason = OFPortReasonSerializerVer13.readFrom(bb);
            bb.skipBytes(7);
            OFPort portNo = OFPort.read4Bytes(bb);
            int lengths = U16.f(bb.readShort());
            bb.skipBytes(2);
            MacAddress hwAddr = MacAddress.read6Bytes(bb);
            bb.skipBytes(2);
            String name = ChannelUtils.readFixedLengthString(bb, 16);
            Set<OFPortConfig> config = OFPortConfigSerializerVer13.readFrom(bb);
            Set<OFPortState> state = OFPortStateSerializerVer13.readFrom(bb);
            U64 ignore = U64.ofRaw(bb.readLong());
            OFCircuitPortStatusVer13 circuitPortStatusVer13 = new OFCircuitPortStatusVer13(xid, reason, portNo, lengths, hwAddr, name, config, state, ignore);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)circuitPortStatusVer13);
            }
            return circuitPortStatusVer13;
        }
    }

    static class Builder
    implements OFCircuitPortStatus.Builder {
        private boolean xidSet;
        private long xid;
        private boolean reasonSet;
        private OFPortReason reason;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean lengthsSet;
        private int lengths;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean nameSet;
        private String name;
        private boolean configSet;
        private Set<OFPortConfig> config;
        private boolean stateSet;
        private Set<OFPortState> state;
        private boolean ignoreSet;
        private U64 ignore;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFCircuitPortStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 7636849L;
        }

        @Override
        public long getExpType() {
            return 12L;
        }

        @Override
        public OFPortReason getReason() {
            return this.reason;
        }

        @Override
        public OFCircuitPortStatus.Builder setReason(OFPortReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFCircuitPortStatus.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public int getLengths() {
            return this.lengths;
        }

        @Override
        public OFCircuitPortStatus.Builder setLengths(int lengths) {
            this.lengths = lengths;
            this.lengthsSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFCircuitPortStatus.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFCircuitPortStatus.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFCircuitPortStatus.Builder setConfig(Set<OFPortConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public Set<OFPortState> getState() {
            return this.state;
        }

        @Override
        public OFCircuitPortStatus.Builder setState(Set<OFPortState> state) {
            this.state = state;
            this.stateSet = true;
            return this;
        }

        @Override
        public U64 getIgnore() {
            return this.ignore;
        }

        @Override
        public OFCircuitPortStatus.Builder setIgnore(U64 ignore) {
            this.ignore = ignore;
            this.ignoreSet = true;
            return this;
        }

        @Override
        public OFCircuitPortStatus build() {
            U64 ignore;
            Set<OFPortState> state;
            Set<OFPortConfig> config;
            String name;
            MacAddress hwAddr;
            OFPort portNo;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.reasonSet) {
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            }
            if (this.reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            int lengths = this.lengthsSet ? this.lengths : 0;
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : DEFAULT_HW_ADDR;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            String string = name = this.nameSet ? this.name : OFCircuitPortStatusVer13.DEFAULT_NAME;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            Set<OFPortConfig> set = config = this.configSet ? this.config : DEFAULT_CONFIG;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            Set<OFPortState> set2 = state = this.stateSet ? this.state : DEFAULT_STATE;
            if (state == null) {
                throw new NullPointerException("Property state must not be null");
            }
            U64 u64 = ignore = this.ignoreSet ? this.ignore : DEFAULT_IGNORE;
            if (ignore == null) {
                throw new NullPointerException("Property ignore must not be null");
            }
            return new OFCircuitPortStatusVer13(xid, this.reason, portNo, lengths, hwAddr, name, config, state, ignore);
        }
    }

    static class BuilderWithParent
    implements OFCircuitPortStatus.Builder {
        final OFCircuitPortStatusVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean reasonSet;
        private OFPortReason reason;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean lengthsSet;
        private int lengths;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean nameSet;
        private String name;
        private boolean configSet;
        private Set<OFPortConfig> config;
        private boolean stateSet;
        private Set<OFPortState> state;
        private boolean ignoreSet;
        private U64 ignore;

        BuilderWithParent(OFCircuitPortStatusVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFCircuitPortStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 7636849L;
        }

        @Override
        public long getExpType() {
            return 12L;
        }

        @Override
        public OFPortReason getReason() {
            return this.reason;
        }

        @Override
        public OFCircuitPortStatus.Builder setReason(OFPortReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFCircuitPortStatus.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public int getLengths() {
            return this.lengths;
        }

        @Override
        public OFCircuitPortStatus.Builder setLengths(int lengths) {
            this.lengths = lengths;
            this.lengthsSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFCircuitPortStatus.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFCircuitPortStatus.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFCircuitPortStatus.Builder setConfig(Set<OFPortConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public Set<OFPortState> getState() {
            return this.state;
        }

        @Override
        public OFCircuitPortStatus.Builder setState(Set<OFPortState> state) {
            this.state = state;
            this.stateSet = true;
            return this;
        }

        @Override
        public U64 getIgnore() {
            return this.ignore;
        }

        @Override
        public OFCircuitPortStatus.Builder setIgnore(U64 ignore) {
            this.ignore = ignore;
            this.ignoreSet = true;
            return this;
        }

        @Override
        public OFCircuitPortStatus build() {
            U64 ignore;
            Set state;
            Set config;
            String name;
            MacAddress hwAddr;
            OFPort portNo;
            OFPortReason reason;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFPortReason oFPortReason = reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            if (reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            int lengths = this.lengthsSet ? this.lengths : this.parentMessage.lengths;
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : this.parentMessage.hwAddr;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            String string = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            Set set = config = this.configSet ? this.config : this.parentMessage.config;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            Set set2 = state = this.stateSet ? this.state : this.parentMessage.state;
            if (state == null) {
                throw new NullPointerException("Property state must not be null");
            }
            U64 u64 = ignore = this.ignoreSet ? this.ignore : this.parentMessage.ignore;
            if (ignore == null) {
                throw new NullPointerException("Property ignore must not be null");
            }
            return new OFCircuitPortStatusVer13(xid, reason, portNo, lengths, hwAddr, name, config, state, ignore);
        }
    }
}

