/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvHeaderSize;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvHeaderSizeVer13
implements OFBsnTlvHeaderSize {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvHeaderSizeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvHeaderSizeVer13 DEFAULT = new OFBsnTlvHeaderSizeVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvHeaderSizeVer13Funnel FUNNEL = new OFBsnTlvHeaderSizeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvHeaderSizeVer13(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 31;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvHeaderSize.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvHeaderSizeVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvHeaderSizeVer13 other = (OFBsnTlvHeaderSizeVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvHeaderSizeVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvHeaderSizeVer13 message) {
            bb.writeShort(31);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvHeaderSizeVer13Funnel
    implements Funnel<OFBsnTlvHeaderSizeVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvHeaderSizeVer13Funnel() {
        }

        public void funnel(OFBsnTlvHeaderSizeVer13 message, PrimitiveSink sink) {
            sink.putShort((short)31);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvHeaderSize> {
        Reader() {
        }

        @Override
        public OFBsnTlvHeaderSize readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 31) {
                throw new OFParseError("Wrong type: Expected=0x1f(0x1f), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvHeaderSizeVer13 bsnTlvHeaderSizeVer13 = new OFBsnTlvHeaderSizeVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvHeaderSizeVer13);
            }
            return bsnTlvHeaderSizeVer13;
        }
    }

    static class Builder
    implements OFBsnTlvHeaderSize.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 31;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHeaderSize.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvHeaderSize build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvHeaderSizeVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvHeaderSize.Builder {
        final OFBsnTlvHeaderSizeVer13 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvHeaderSizeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 31;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHeaderSize.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvHeaderSize build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvHeaderSizeVer13(value);
        }
    }
}

