/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnDebugCounterDescStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnDebugCounterDescStatsEntryVer13
implements OFBsnDebugCounterDescStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnDebugCounterDescStatsEntryVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 328;
    private static final U64 DEFAULT_COUNTER_ID = U64.ZERO;
    private static final String DEFAULT_NAME = "";
    private static final String DEFAULT_DESCRIPTION = "";
    private final U64 counterId;
    private final String name;
    private final String description;
    static final OFBsnDebugCounterDescStatsEntryVer13 DEFAULT = new OFBsnDebugCounterDescStatsEntryVer13(DEFAULT_COUNTER_ID, "", "");
    static final Reader READER = new Reader();
    static final OFBsnDebugCounterDescStatsEntryVer13Funnel FUNNEL = new OFBsnDebugCounterDescStatsEntryVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnDebugCounterDescStatsEntryVer13(U64 counterId, String name, String description) {
        if (counterId == null) {
            throw new NullPointerException("OFBsnDebugCounterDescStatsEntryVer13: property counterId cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("OFBsnDebugCounterDescStatsEntryVer13: property name cannot be null");
        }
        if (description == null) {
            throw new NullPointerException("OFBsnDebugCounterDescStatsEntryVer13: property description cannot be null");
        }
        this.counterId = counterId;
        this.name = name;
        this.description = description;
    }

    @Override
    public U64 getCounterId() {
        return this.counterId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnDebugCounterDescStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnDebugCounterDescStatsEntryVer13(");
        b.append("counterId=").append(this.counterId);
        b.append(", ");
        b.append("name=").append(this.name);
        b.append(", ");
        b.append("description=").append(this.description);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnDebugCounterDescStatsEntryVer13 other = (OFBsnDebugCounterDescStatsEntryVer13)obj;
        if (this.counterId == null ? other.counterId != null : !this.counterId.equals(other.counterId)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.description == null ? other.description != null : !this.description.equals(other.description));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.counterId == null ? 0 : this.counterId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnDebugCounterDescStatsEntryVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnDebugCounterDescStatsEntryVer13 message) {
            bb.writeLong(message.counterId.getValue());
            ChannelUtils.writeFixedLengthString(bb, message.name, 64);
            ChannelUtils.writeFixedLengthString(bb, message.description, 256);
        }
    }

    static class OFBsnDebugCounterDescStatsEntryVer13Funnel
    implements Funnel<OFBsnDebugCounterDescStatsEntryVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnDebugCounterDescStatsEntryVer13Funnel() {
        }

        public void funnel(OFBsnDebugCounterDescStatsEntryVer13 message, PrimitiveSink sink) {
            message.counterId.putTo(sink);
            sink.putUnencodedChars((CharSequence)message.name);
            sink.putUnencodedChars((CharSequence)message.description);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnDebugCounterDescStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnDebugCounterDescStatsEntry readFrom(ChannelBuffer bb) throws OFParseError {
            U64 counterId = U64.ofRaw(bb.readLong());
            String name = ChannelUtils.readFixedLengthString(bb, 64);
            String description = ChannelUtils.readFixedLengthString(bb, 256);
            OFBsnDebugCounterDescStatsEntryVer13 bsnDebugCounterDescStatsEntryVer13 = new OFBsnDebugCounterDescStatsEntryVer13(counterId, name, description);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnDebugCounterDescStatsEntryVer13);
            }
            return bsnDebugCounterDescStatsEntryVer13;
        }
    }

    static class Builder
    implements OFBsnDebugCounterDescStatsEntry.Builder {
        private boolean counterIdSet;
        private U64 counterId;
        private boolean nameSet;
        private String name;
        private boolean descriptionSet;
        private String description;

        Builder() {
        }

        @Override
        public U64 getCounterId() {
            return this.counterId;
        }

        @Override
        public OFBsnDebugCounterDescStatsEntry.Builder setCounterId(U64 counterId) {
            this.counterId = counterId;
            this.counterIdSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFBsnDebugCounterDescStatsEntry.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public OFBsnDebugCounterDescStatsEntry.Builder setDescription(String description) {
            this.description = description;
            this.descriptionSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnDebugCounterDescStatsEntry build() {
            String description;
            String name;
            U64 counterId;
            U64 u64 = counterId = this.counterIdSet ? this.counterId : DEFAULT_COUNTER_ID;
            if (counterId == null) {
                throw new NullPointerException("Property counterId must not be null");
            }
            String string = name = this.nameSet ? this.name : "";
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            String string2 = description = this.descriptionSet ? this.description : "";
            if (description == null) {
                throw new NullPointerException("Property description must not be null");
            }
            return new OFBsnDebugCounterDescStatsEntryVer13(counterId, name, description);
        }
    }

    static class BuilderWithParent
    implements OFBsnDebugCounterDescStatsEntry.Builder {
        final OFBsnDebugCounterDescStatsEntryVer13 parentMessage;
        private boolean counterIdSet;
        private U64 counterId;
        private boolean nameSet;
        private String name;
        private boolean descriptionSet;
        private String description;

        BuilderWithParent(OFBsnDebugCounterDescStatsEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public U64 getCounterId() {
            return this.counterId;
        }

        @Override
        public OFBsnDebugCounterDescStatsEntry.Builder setCounterId(U64 counterId) {
            this.counterId = counterId;
            this.counterIdSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFBsnDebugCounterDescStatsEntry.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public OFBsnDebugCounterDescStatsEntry.Builder setDescription(String description) {
            this.description = description;
            this.descriptionSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnDebugCounterDescStatsEntry build() {
            String description;
            String name;
            U64 counterId;
            U64 u64 = counterId = this.counterIdSet ? this.counterId : this.parentMessage.counterId;
            if (counterId == null) {
                throw new NullPointerException("Property counterId must not be null");
            }
            String string = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            String string2 = description = this.descriptionSet ? this.description : this.parentMessage.description;
            if (description == null) {
                throw new NullPointerException("Property description must not be null");
            }
            return new OFBsnDebugCounterDescStatsEntryVer13(counterId, name, description);
        }
    }
}

