/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.action.OFActionOfdpa;
import org.projectfloodlight.openflow.protocol.ver13.OFActionOfdpaPopCwVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFActionOfdpaPopL2HeaderVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFActionOfdpaPushCwVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFActionOfdpaPushL2HeaderVer13;
import org.projectfloodlight.openflow.types.U16;

abstract class OFActionOfdpaVer13 {
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFActionOfdpaVer13() {
    }

    static class Reader
    implements OFMessageReader<OFActionOfdpa> {
        Reader() {
        }

        @Override
        public OFActionOfdpa readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            int experimenter = bb.readInt();
            if (experimenter != 4120) {
                throw new OFParseError("Wrong experimenter: Expected=0x1018L(0x1018L), got=" + experimenter);
            }
            short expType = bb.readShort();
            bb.readerIndex(start);
            switch (expType) {
                case 4: {
                    return OFActionOfdpaPopCwVer13.READER.readFrom(bb);
                }
                case 2: {
                    return OFActionOfdpaPopL2HeaderVer13.READER.readFrom(bb);
                }
                case 3: {
                    return OFActionOfdpaPushCwVer13.READER.readFrom(bb);
                }
                case 1: {
                    return OFActionOfdpaPushL2HeaderVer13.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator expType of class OFActionOfdpaVer13: " + expType);
        }
    }
}

