/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionOfdpaPushCw;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionOfdpaPushCwVer13
implements OFActionOfdpaPushCw {
    private static final Logger logger = LoggerFactory.getLogger(OFActionOfdpaPushCwVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 16;
    static final OFActionOfdpaPushCwVer13 DEFAULT = new OFActionOfdpaPushCwVer13();
    static final OFActionOfdpaPushCwVer13 INSTANCE = new OFActionOfdpaPushCwVer13();
    static final Reader READER = new Reader();
    static final OFActionOfdpaPushCwVer13Funnel FUNNEL = new OFActionOfdpaPushCwVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFActionOfdpaPushCwVer13() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 4120L;
    }

    @Override
    public int getExpType() {
        return 3;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionOfdpaPushCw.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionOfdpaPushCwVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionOfdpaPushCwVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionOfdpaPushCwVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionOfdpaPushCwVer13 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(4120);
            bb.writeShort(3);
            bb.writeZero(6);
        }
    }

    static class OFActionOfdpaPushCwVer13Funnel
    implements Funnel<OFActionOfdpaPushCwVer13> {
        private static final long serialVersionUID = 1L;

        OFActionOfdpaPushCwVer13Funnel() {
        }

        public void funnel(OFActionOfdpaPushCwVer13 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(4120);
            sink.putShort((short)3);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionOfdpaPushCw> {
        Reader() {
        }

        @Override
        public OFActionOfdpaPushCw readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 4120) {
                throw new OFParseError("Wrong experimenter: Expected=0x1018L(0x1018L), got=" + experimenter);
            }
            short expType = bb.readShort();
            if (expType != 3) {
                throw new OFParseError("Wrong expType: Expected=0x3(0x3), got=" + expType);
            }
            bb.skipBytes(6);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

