/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdOfdpaPopCw;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdOfdpaPopCwVer13
implements OFActionIdOfdpaPopCw {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdOfdpaPopCwVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 10;
    static final OFActionIdOfdpaPopCwVer13 DEFAULT = new OFActionIdOfdpaPopCwVer13();
    static final OFActionIdOfdpaPopCwVer13 INSTANCE = new OFActionIdOfdpaPopCwVer13();
    static final Reader READER = new Reader();
    static final OFActionIdOfdpaPopCwVer13Funnel FUNNEL = new OFActionIdOfdpaPopCwVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdOfdpaPopCwVer13() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 4120L;
    }

    @Override
    public int getExpType() {
        return 4;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionIdOfdpaPopCw.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdOfdpaPopCwVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdOfdpaPopCwVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdOfdpaPopCwVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionIdOfdpaPopCwVer13 message) {
            bb.writeShort(-1);
            bb.writeShort(10);
            bb.writeInt(4120);
            bb.writeShort(4);
        }
    }

    static class OFActionIdOfdpaPopCwVer13Funnel
    implements Funnel<OFActionIdOfdpaPopCwVer13> {
        private static final long serialVersionUID = 1L;

        OFActionIdOfdpaPopCwVer13Funnel() {
        }

        public void funnel(OFActionIdOfdpaPopCwVer13 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)10);
            sink.putInt(4120);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdOfdpaPopCw> {
        Reader() {
        }

        @Override
        public OFActionIdOfdpaPopCw readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 10) {
                throw new OFParseError("Wrong length: Expected=10(10), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 4120) {
                throw new OFParseError("Wrong experimenter: Expected=0x1018L(0x1018L), got=" + experimenter);
            }
            short expType = bb.readShort();
            if (expType != 4) {
                throw new OFParseError("Wrong expType: Expected=0x4(0x4), got=" + expType);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

