/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdNiciraPopNsh;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdNiciraPopNshVer13
implements OFActionIdNiciraPopNsh {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdNiciraPopNshVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 10;
    static final OFActionIdNiciraPopNshVer13 DEFAULT = new OFActionIdNiciraPopNshVer13();
    static final OFActionIdNiciraPopNshVer13 INSTANCE = new OFActionIdNiciraPopNshVer13();
    static final Reader READER = new Reader();
    static final OFActionIdNiciraPopNshVer13Funnel FUNNEL = new OFActionIdNiciraPopNshVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdNiciraPopNshVer13() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 39;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionIdNiciraPopNsh.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdNiciraPopNshVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdNiciraPopNshVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdNiciraPopNshVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionIdNiciraPopNshVer13 message) {
            bb.writeShort(-1);
            bb.writeShort(10);
            bb.writeInt(8992);
            bb.writeShort(39);
        }
    }

    static class OFActionIdNiciraPopNshVer13Funnel
    implements Funnel<OFActionIdNiciraPopNshVer13> {
        private static final long serialVersionUID = 1L;

        OFActionIdNiciraPopNshVer13Funnel() {
        }

        public void funnel(OFActionIdNiciraPopNshVer13 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)10);
            sink.putInt(8992);
            sink.putShort((short)39);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdNiciraPopNsh> {
        Reader() {
        }

        @Override
        public OFActionIdNiciraPopNsh readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 10) {
                throw new OFParseError("Wrong length: Expected=10(10), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 39) {
                throw new OFParseError("Wrong subtype: Expected=0x27(0x27), got=" + subtype);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

