/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdNiciraNat;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdNiciraNatVer13
implements OFActionIdNiciraNat {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdNiciraNatVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 10;
    static final OFActionIdNiciraNatVer13 DEFAULT = new OFActionIdNiciraNatVer13();
    static final OFActionIdNiciraNatVer13 INSTANCE = new OFActionIdNiciraNatVer13();
    static final Reader READER = new Reader();
    static final OFActionIdNiciraNatVer13Funnel FUNNEL = new OFActionIdNiciraNatVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdNiciraNatVer13() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 36;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionIdNiciraNat.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdNiciraNatVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdNiciraNatVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdNiciraNatVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionIdNiciraNatVer13 message) {
            bb.writeShort(-1);
            bb.writeShort(10);
            bb.writeInt(8992);
            bb.writeShort(36);
        }
    }

    static class OFActionIdNiciraNatVer13Funnel
    implements Funnel<OFActionIdNiciraNatVer13> {
        private static final long serialVersionUID = 1L;

        OFActionIdNiciraNatVer13Funnel() {
        }

        public void funnel(OFActionIdNiciraNatVer13 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)10);
            sink.putInt(8992);
            sink.putShort((short)36);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdNiciraNat> {
        Reader() {
        }

        @Override
        public OFActionIdNiciraNat readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 10) {
                throw new OFParseError("Wrong length: Expected=10(10), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 36) {
                throw new OFParseError("Wrong subtype: Expected=0x24(0x24), got=" + subtype);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

