/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortReason;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver12.OFPortDescVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFPortReasonSerializerVer12;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortStatusVer12
implements OFPortStatus {
    private static final Logger logger = LoggerFactory.getLogger(OFPortStatusVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 80;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    private final OFPortReason reason;
    private final OFPortDesc desc;
    static final Reader READER = new Reader();
    static final OFPortStatusVer12Funnel FUNNEL = new OFPortStatusVer12Funnel();
    static final Writer WRITER = new Writer();

    OFPortStatusVer12(long xid, OFPortReason reason, OFPortDesc desc) {
        if (reason == null) {
            throw new NullPointerException("OFPortStatusVer12: property reason cannot be null");
        }
        if (desc == null) {
            throw new NullPointerException("OFPortStatusVer12: property desc cannot be null");
        }
        this.xid = xid;
        this.reason = reason;
        this.desc = desc;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFType getType() {
        return OFType.PORT_STATUS;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFPortReason getReason() {
        return this.reason;
    }

    @Override
    public OFPortDesc getDesc() {
        return this.desc;
    }

    @Override
    public OFPortStatus.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortStatusVer12(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("reason=").append((Object)this.reason);
        b.append(", ");
        b.append("desc=").append(this.desc);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortStatusVer12 other = (OFPortStatusVer12)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        return !(this.desc == null ? other.desc != null : !this.desc.equals(other.desc));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortStatusVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFPortStatusVer12 message) {
            bb.writeByte(3);
            bb.writeByte(12);
            bb.writeShort(80);
            bb.writeInt(U32.t(message.xid));
            OFPortReasonSerializerVer12.writeTo(bb, message.reason);
            bb.writeZero(7);
            message.desc.writeTo(bb);
        }
    }

    static class OFPortStatusVer12Funnel
    implements Funnel<OFPortStatusVer12> {
        private static final long serialVersionUID = 1L;

        OFPortStatusVer12Funnel() {
        }

        public void funnel(OFPortStatusVer12 message, PrimitiveSink sink) {
            sink.putByte((byte)3);
            sink.putByte((byte)12);
            sink.putShort((short)80);
            sink.putLong(message.xid);
            OFPortReasonSerializerVer12.putTo(message.reason, sink);
            message.desc.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortStatus> {
        Reader() {
        }

        @Override
        public OFPortStatus readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 12) {
                throw new OFParseError("Wrong type: Expected=OFType.PORT_STATUS(12), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 80) {
                throw new OFParseError("Wrong length: Expected=80(80), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFPortReason reason = OFPortReasonSerializerVer12.readFrom(bb);
            bb.skipBytes(7);
            OFPortDesc desc = OFPortDescVer12.READER.readFrom(bb);
            OFPortStatusVer12 portStatusVer12 = new OFPortStatusVer12(xid, reason, desc);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portStatusVer12);
            }
            return portStatusVer12;
        }
    }

    static class Builder
    implements OFPortStatus.Builder {
        private boolean xidSet;
        private long xid;
        private boolean reasonSet;
        private OFPortReason reason;
        private boolean descSet;
        private OFPortDesc desc;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.PORT_STATUS;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFPortReason getReason() {
            return this.reason;
        }

        @Override
        public OFPortStatus.Builder setReason(OFPortReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public OFPortDesc getDesc() {
            return this.desc;
        }

        @Override
        public OFPortStatus.Builder setDesc(OFPortDesc desc) {
            this.desc = desc;
            this.descSet = true;
            return this;
        }

        @Override
        public OFPortStatus build() {
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.reasonSet) {
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            }
            if (this.reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            if (!this.descSet) {
                throw new IllegalStateException("Property desc doesn't have default value -- must be set");
            }
            if (this.desc == null) {
                throw new NullPointerException("Property desc must not be null");
            }
            return new OFPortStatusVer12(xid, this.reason, this.desc);
        }
    }

    static class BuilderWithParent
    implements OFPortStatus.Builder {
        final OFPortStatusVer12 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean reasonSet;
        private OFPortReason reason;
        private boolean descSet;
        private OFPortDesc desc;

        BuilderWithParent(OFPortStatusVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.PORT_STATUS;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFPortReason getReason() {
            return this.reason;
        }

        @Override
        public OFPortStatus.Builder setReason(OFPortReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public OFPortDesc getDesc() {
            return this.desc;
        }

        @Override
        public OFPortStatus.Builder setDesc(OFPortDesc desc) {
            this.desc = desc;
            this.descSet = true;
            return this;
        }

        @Override
        public OFPortStatus build() {
            OFPortDesc desc;
            OFPortReason reason;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFPortReason oFPortReason = reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            if (reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            OFPortDesc oFPortDesc = desc = this.descSet ? this.desc : this.parentMessage.desc;
            if (desc == null) {
                throw new NullPointerException("Property desc must not be null");
            }
            return new OFPortStatusVer12(xid, reason, desc);
        }
    }
}

