/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmTunFlags;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmTunFlagsVer12
implements OFOxmTunFlags {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmTunFlagsVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 6;
    private static final U16 DEFAULT_VALUE = U16.ZERO;
    private final U16 value;
    static final OFOxmTunFlagsVer12 DEFAULT = new OFOxmTunFlagsVer12(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmTunFlagsVer12Funnel FUNNEL = new OFOxmTunFlagsVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmTunFlagsVer12(U16 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmTunFlagsVer12: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 118786L;
    }

    @Override
    public U16 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U16> getMatchField() {
        return MatchField.TUN_FLAGS;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U16> getCanonical() {
        return this;
    }

    @Override
    public U16 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmTunFlags.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmTunFlagsVer12(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmTunFlagsVer12 other = (OFOxmTunFlagsVer12)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmTunFlagsVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmTunFlagsVer12 message) {
            bb.writeInt(118786);
            bb.writeShort((int)message.value.getRaw());
        }
    }

    static class OFOxmTunFlagsVer12Funnel
    implements Funnel<OFOxmTunFlagsVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmTunFlagsVer12Funnel() {
        }

        public void funnel(OFOxmTunFlagsVer12 message, PrimitiveSink sink) {
            sink.putInt(118786);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmTunFlags> {
        Reader() {
        }

        @Override
        public OFOxmTunFlags readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 118786) {
                throw new OFParseError("Wrong typeLen: Expected=0x1d002L(0x1d002L), got=" + typeLen);
            }
            U16 value = U16.of(bb.readShort());
            OFOxmTunFlagsVer12 oxmTunFlagsVer12 = new OFOxmTunFlagsVer12(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmTunFlagsVer12);
            }
            return oxmTunFlagsVer12;
        }
    }

    static class Builder
    implements OFOxmTunFlags.Builder {
        private boolean valueSet;
        private U16 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 118786L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunFlags.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.TUN_FLAGS;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmTunFlags build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunFlagsVer12(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmTunFlags.Builder {
        final OFOxmTunFlagsVer12 parentMessage;
        private boolean valueSet;
        private U16 value;

        BuilderWithParent(OFOxmTunFlagsVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 118786L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunFlags.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.TUN_FLAGS;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmTunFlags build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunFlagsVer12(value);
        }
    }
}

