/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmMetadataMasked;
import org.projectfloodlight.openflow.protocol.ver12.OFOxmMetadataVer12;
import org.projectfloodlight.openflow.types.OFMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmMetadataMaskedVer12
implements OFOxmMetadataMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmMetadataMaskedVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 20;
    private static final OFMetadata DEFAULT_VALUE = OFMetadata.NONE;
    private static final OFMetadata DEFAULT_VALUE_MASK = OFMetadata.NONE;
    private final OFMetadata value;
    private final OFMetadata mask;
    static final OFOxmMetadataMaskedVer12 DEFAULT = new OFOxmMetadataMaskedVer12(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmMetadataMaskedVer12Funnel FUNNEL = new OFOxmMetadataMaskedVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmMetadataMaskedVer12(OFMetadata value, OFMetadata mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmMetadataMaskedVer12: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmMetadataMaskedVer12: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147484944L;
    }

    @Override
    public OFMetadata getValue() {
        return this.value;
    }

    @Override
    public OFMetadata getMask() {
        return this.mask;
    }

    @Override
    public MatchField<OFMetadata> getMatchField() {
        return MatchField.METADATA;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<OFMetadata> getCanonical() {
        if (OFMetadata.NO_MASK.equals(this.mask)) {
            return new OFOxmMetadataVer12(this.value);
        }
        if (OFMetadata.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmMetadataMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmMetadataMaskedVer12(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmMetadataMaskedVer12 other = (OFOxmMetadataMaskedVer12)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmMetadataMaskedVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmMetadataMaskedVer12 message) {
            bb.writeInt(-2147482352);
            message.value.write8Bytes(bb);
            message.mask.write8Bytes(bb);
        }
    }

    static class OFOxmMetadataMaskedVer12Funnel
    implements Funnel<OFOxmMetadataMaskedVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmMetadataMaskedVer12Funnel() {
        }

        public void funnel(OFOxmMetadataMaskedVer12 message, PrimitiveSink sink) {
            sink.putInt(-2147482352);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmMetadataMasked> {
        Reader() {
        }

        @Override
        public OFOxmMetadataMasked readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147482352) {
                throw new OFParseError("Wrong typeLen: Expected=0x80000510L(0x80000510L), got=" + typeLen);
            }
            OFMetadata value = OFMetadata.read8Bytes(bb);
            OFMetadata mask = OFMetadata.read8Bytes(bb);
            OFOxmMetadataMaskedVer12 oxmMetadataMaskedVer12 = new OFOxmMetadataMaskedVer12(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmMetadataMaskedVer12);
            }
            return oxmMetadataMaskedVer12;
        }
    }

    static class Builder
    implements OFOxmMetadataMasked.Builder {
        private boolean valueSet;
        private OFMetadata value;
        private boolean maskSet;
        private OFMetadata mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147484944L;
        }

        @Override
        public OFMetadata getValue() {
            return this.value;
        }

        @Override
        public OFOxmMetadataMasked.Builder setValue(OFMetadata value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFMetadata getMask() {
            return this.mask;
        }

        @Override
        public OFOxmMetadataMasked.Builder setMask(OFMetadata mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFMetadata> getMatchField() {
            return MatchField.METADATA;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFMetadata> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmMetadataMasked build() {
            OFMetadata mask;
            OFMetadata value;
            OFMetadata oFMetadata = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFMetadata oFMetadata2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmMetadataMaskedVer12(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmMetadataMasked.Builder {
        final OFOxmMetadataMaskedVer12 parentMessage;
        private boolean valueSet;
        private OFMetadata value;
        private boolean maskSet;
        private OFMetadata mask;

        BuilderWithParent(OFOxmMetadataMaskedVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147484944L;
        }

        @Override
        public OFMetadata getValue() {
            return this.value;
        }

        @Override
        public OFOxmMetadataMasked.Builder setValue(OFMetadata value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFMetadata getMask() {
            return this.mask;
        }

        @Override
        public OFOxmMetadataMasked.Builder setMask(OFMetadata mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFMetadata> getMatchField() {
            return MatchField.METADATA;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFMetadata> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmMetadataMasked build() {
            OFMetadata mask;
            OFMetadata value;
            OFMetadata oFMetadata = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFMetadata oFMetadata2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmMetadataMaskedVer12(value, mask);
        }
    }
}

