/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmEncapEthType;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmEncapEthTypeVer12
implements OFOxmEncapEthType {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmEncapEthTypeVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 6;
    private static final U16 DEFAULT_VALUE = U16.ZERO;
    private final U16 value;
    static final OFOxmEncapEthTypeVer12 DEFAULT = new OFOxmEncapEthTypeVer12(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmEncapEthTypeVer12Funnel FUNNEL = new OFOxmEncapEthTypeVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmEncapEthTypeVer12(U16 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmEncapEthTypeVer12: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 128514L;
    }

    @Override
    public U16 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U16> getMatchField() {
        return MatchField.ENCAP_ETH_TYPE;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U16> getCanonical() {
        return this;
    }

    @Override
    public U16 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmEncapEthType.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmEncapEthTypeVer12(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmEncapEthTypeVer12 other = (OFOxmEncapEthTypeVer12)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmEncapEthTypeVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmEncapEthTypeVer12 message) {
            bb.writeInt(128514);
            bb.writeShort((int)message.value.getRaw());
        }
    }

    static class OFOxmEncapEthTypeVer12Funnel
    implements Funnel<OFOxmEncapEthTypeVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmEncapEthTypeVer12Funnel() {
        }

        public void funnel(OFOxmEncapEthTypeVer12 message, PrimitiveSink sink) {
            sink.putInt(128514);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmEncapEthType> {
        Reader() {
        }

        @Override
        public OFOxmEncapEthType readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 128514) {
                throw new OFParseError("Wrong typeLen: Expected=0x1f602L(0x1f602L), got=" + typeLen);
            }
            U16 value = U16.of(bb.readShort());
            OFOxmEncapEthTypeVer12 oxmEncapEthTypeVer12 = new OFOxmEncapEthTypeVer12(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmEncapEthTypeVer12);
            }
            return oxmEncapEthTypeVer12;
        }
    }

    static class Builder
    implements OFOxmEncapEthType.Builder {
        private boolean valueSet;
        private U16 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 128514L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmEncapEthType.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.ENCAP_ETH_TYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmEncapEthType build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmEncapEthTypeVer12(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmEncapEthType.Builder {
        final OFOxmEncapEthTypeVer12 parentMessage;
        private boolean valueSet;
        private U16 value;

        BuilderWithParent(OFOxmEncapEthTypeVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 128514L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmEncapEthType.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.ENCAP_ETH_TYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmEncapEthType build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmEncapEthTypeVer12(value);
        }
    }
}

