/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraNat;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionNiciraNatVer12
implements OFActionNiciraNat {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraNatVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int MINIMUM_LENGTH = 16;
    private static final int DEFAULT_FLAGS = 0;
    private static final int DEFAULT_RANGE_PRESENT = 0;
    private static final List<IPv4Address> DEFAULT_IPV4_RANGE = ImmutableList.of();
    private static final List<IPv6Address> DEFAULT_IPV6_RANGE = ImmutableList.of();
    private static final List<U16> DEFAULT_PORT_RANGE = ImmutableList.of();
    private static final List<U8> DEFAULT_PAD = ImmutableList.of();
    private final int flags;
    private final int rangePresent;
    private final List<IPv4Address> ipv4Range;
    private final List<IPv6Address> ipv6Range;
    private final List<U16> portRange;
    private final List<U8> pad;
    static final OFActionNiciraNatVer12 DEFAULT = new OFActionNiciraNatVer12(0, 0, DEFAULT_IPV4_RANGE, DEFAULT_IPV6_RANGE, DEFAULT_PORT_RANGE, DEFAULT_PAD);
    static final Reader READER = new Reader();
    static final OFActionNiciraNatVer12Funnel FUNNEL = new OFActionNiciraNatVer12Funnel();
    static final Writer WRITER = new Writer();

    OFActionNiciraNatVer12(int flags, int rangePresent, List<IPv4Address> ipv4Range, List<IPv6Address> ipv6Range, List<U16> portRange, List<U8> pad) {
        if (ipv4Range == null) {
            throw new NullPointerException("OFActionNiciraNatVer12: property ipv4Range cannot be null");
        }
        if (ipv6Range == null) {
            throw new NullPointerException("OFActionNiciraNatVer12: property ipv6Range cannot be null");
        }
        if (portRange == null) {
            throw new NullPointerException("OFActionNiciraNatVer12: property portRange cannot be null");
        }
        if (pad == null) {
            throw new NullPointerException("OFActionNiciraNatVer12: property pad cannot be null");
        }
        this.flags = flags;
        this.rangePresent = rangePresent;
        this.ipv4Range = ipv4Range;
        this.ipv6Range = ipv6Range;
        this.portRange = portRange;
        this.pad = pad;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 36;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public int getRangePresent() {
        return this.rangePresent;
    }

    @Override
    public List<IPv4Address> getIpv4Range() {
        return this.ipv4Range;
    }

    @Override
    public List<IPv6Address> getIpv6Range() {
        return this.ipv6Range;
    }

    @Override
    public List<U16> getPortRange() {
        return this.portRange;
    }

    @Override
    public List<U8> getPad() {
        return this.pad;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFActionNiciraNat.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraNatVer12(");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("rangePresent=").append(this.rangePresent);
        b.append(", ");
        b.append("ipv4Range=").append(this.ipv4Range);
        b.append(", ");
        b.append("ipv6Range=").append(this.ipv6Range);
        b.append(", ");
        b.append("portRange=").append(this.portRange);
        b.append(", ");
        b.append("pad=").append(this.pad);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionNiciraNatVer12 other = (OFActionNiciraNatVer12)obj;
        if (this.flags != other.flags) {
            return false;
        }
        if (this.rangePresent != other.rangePresent) {
            return false;
        }
        if (this.ipv4Range == null ? other.ipv4Range != null : !this.ipv4Range.equals(other.ipv4Range)) {
            return false;
        }
        if (this.ipv6Range == null ? other.ipv6Range != null : !this.ipv6Range.equals(other.ipv6Range)) {
            return false;
        }
        if (this.portRange == null ? other.portRange != null : !this.portRange.equals(other.portRange)) {
            return false;
        }
        return !(this.pad == null ? other.pad != null : !this.pad.equals(other.pad));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.flags;
        result = 31 * result + this.rangePresent;
        result = 31 * result + (this.ipv4Range == null ? 0 : this.ipv4Range.hashCode());
        result = 31 * result + (this.ipv6Range == null ? 0 : this.ipv6Range.hashCode());
        result = 31 * result + (this.portRange == null ? 0 : this.portRange.hashCode());
        result = 31 * result + (this.pad == null ? 0 : this.pad.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionNiciraNatVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionNiciraNatVer12 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(-1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(8992);
            bb.writeShort(36);
            bb.writeZero(2);
            bb.writeShort((int)U16.t(message.flags));
            bb.writeShort((int)U16.t(message.rangePresent));
            ChannelUtils.writeList(bb, message.ipv4Range);
            ChannelUtils.writeList(bb, message.ipv6Range);
            ChannelUtils.writeList(bb, message.portRange);
            ChannelUtils.writeList(bb, message.pad);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFActionNiciraNatVer12Funnel
    implements Funnel<OFActionNiciraNatVer12> {
        private static final long serialVersionUID = 1L;

        OFActionNiciraNatVer12Funnel() {
        }

        public void funnel(OFActionNiciraNatVer12 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putInt(8992);
            sink.putShort((short)36);
            sink.putInt(message.flags);
            sink.putInt(message.rangePresent);
            FunnelUtils.putList(message.ipv4Range, sink);
            FunnelUtils.putList(message.ipv6Range, sink);
            FunnelUtils.putList(message.portRange, sink);
            FunnelUtils.putList(message.pad, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionNiciraNat> {
        Reader() {
        }

        @Override
        public OFActionNiciraNat readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 36) {
                throw new OFParseError("Wrong subtype: Expected=0x24(0x24), got=" + subtype);
            }
            bb.skipBytes(2);
            int flags = U16.f(bb.readShort());
            int rangePresent = U16.f(bb.readShort());
            List<IPv4Address> ipv4Range = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), IPv4Address.READER);
            List<IPv6Address> ipv6Range = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), IPv6Address.READER);
            List<U16> portRange = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U16.READER);
            List<U8> pad = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U8.READER);
            OFActionNiciraNatVer12 actionNiciraNatVer12 = new OFActionNiciraNatVer12(flags, rangePresent, ipv4Range, ipv6Range, portRange, pad);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionNiciraNatVer12);
            }
            return actionNiciraNatVer12;
        }
    }

    static class Builder
    implements OFActionNiciraNat.Builder {
        private boolean flagsSet;
        private int flags;
        private boolean rangePresentSet;
        private int rangePresent;
        private boolean ipv4RangeSet;
        private List<IPv4Address> ipv4Range;
        private boolean ipv6RangeSet;
        private List<IPv6Address> ipv6Range;
        private boolean portRangeSet;
        private List<U16> portRange;
        private boolean padSet;
        private List<U8> pad;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 36;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public OFActionNiciraNat.Builder setFlags(int flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public int getRangePresent() {
            return this.rangePresent;
        }

        @Override
        public OFActionNiciraNat.Builder setRangePresent(int rangePresent) {
            this.rangePresent = rangePresent;
            this.rangePresentSet = true;
            return this;
        }

        @Override
        public List<IPv4Address> getIpv4Range() {
            return this.ipv4Range;
        }

        @Override
        public OFActionNiciraNat.Builder setIpv4Range(List<IPv4Address> ipv4Range) {
            this.ipv4Range = ipv4Range;
            this.ipv4RangeSet = true;
            return this;
        }

        @Override
        public List<IPv6Address> getIpv6Range() {
            return this.ipv6Range;
        }

        @Override
        public OFActionNiciraNat.Builder setIpv6Range(List<IPv6Address> ipv6Range) {
            this.ipv6Range = ipv6Range;
            this.ipv6RangeSet = true;
            return this;
        }

        @Override
        public List<U16> getPortRange() {
            return this.portRange;
        }

        @Override
        public OFActionNiciraNat.Builder setPortRange(List<U16> portRange) {
            this.portRange = portRange;
            this.portRangeSet = true;
            return this;
        }

        @Override
        public List<U8> getPad() {
            return this.pad;
        }

        @Override
        public OFActionNiciraNat.Builder setPad(List<U8> pad) {
            this.pad = pad;
            this.padSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFActionNiciraNat build() {
            List<U8> pad;
            List<U16> portRange;
            List<IPv6Address> ipv6Range;
            List<IPv4Address> ipv4Range;
            int flags = this.flagsSet ? this.flags : 0;
            int rangePresent = this.rangePresentSet ? this.rangePresent : 0;
            List<IPv4Address> list = ipv4Range = this.ipv4RangeSet ? this.ipv4Range : DEFAULT_IPV4_RANGE;
            if (ipv4Range == null) {
                throw new NullPointerException("Property ipv4Range must not be null");
            }
            List<IPv6Address> list2 = ipv6Range = this.ipv6RangeSet ? this.ipv6Range : DEFAULT_IPV6_RANGE;
            if (ipv6Range == null) {
                throw new NullPointerException("Property ipv6Range must not be null");
            }
            List<U16> list3 = portRange = this.portRangeSet ? this.portRange : DEFAULT_PORT_RANGE;
            if (portRange == null) {
                throw new NullPointerException("Property portRange must not be null");
            }
            List<U8> list4 = pad = this.padSet ? this.pad : DEFAULT_PAD;
            if (pad == null) {
                throw new NullPointerException("Property pad must not be null");
            }
            return new OFActionNiciraNatVer12(flags, rangePresent, ipv4Range, ipv6Range, portRange, pad);
        }
    }

    static class BuilderWithParent
    implements OFActionNiciraNat.Builder {
        final OFActionNiciraNatVer12 parentMessage;
        private boolean flagsSet;
        private int flags;
        private boolean rangePresentSet;
        private int rangePresent;
        private boolean ipv4RangeSet;
        private List<IPv4Address> ipv4Range;
        private boolean ipv6RangeSet;
        private List<IPv6Address> ipv6Range;
        private boolean portRangeSet;
        private List<U16> portRange;
        private boolean padSet;
        private List<U8> pad;

        BuilderWithParent(OFActionNiciraNatVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 36;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public OFActionNiciraNat.Builder setFlags(int flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public int getRangePresent() {
            return this.rangePresent;
        }

        @Override
        public OFActionNiciraNat.Builder setRangePresent(int rangePresent) {
            this.rangePresent = rangePresent;
            this.rangePresentSet = true;
            return this;
        }

        @Override
        public List<IPv4Address> getIpv4Range() {
            return this.ipv4Range;
        }

        @Override
        public OFActionNiciraNat.Builder setIpv4Range(List<IPv4Address> ipv4Range) {
            this.ipv4Range = ipv4Range;
            this.ipv4RangeSet = true;
            return this;
        }

        @Override
        public List<IPv6Address> getIpv6Range() {
            return this.ipv6Range;
        }

        @Override
        public OFActionNiciraNat.Builder setIpv6Range(List<IPv6Address> ipv6Range) {
            this.ipv6Range = ipv6Range;
            this.ipv6RangeSet = true;
            return this;
        }

        @Override
        public List<U16> getPortRange() {
            return this.portRange;
        }

        @Override
        public OFActionNiciraNat.Builder setPortRange(List<U16> portRange) {
            this.portRange = portRange;
            this.portRangeSet = true;
            return this;
        }

        @Override
        public List<U8> getPad() {
            return this.pad;
        }

        @Override
        public OFActionNiciraNat.Builder setPad(List<U8> pad) {
            this.pad = pad;
            this.padSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFActionNiciraNat build() {
            List pad;
            List portRange;
            List ipv6Range;
            List ipv4Range;
            int flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            int rangePresent = this.rangePresentSet ? this.rangePresent : this.parentMessage.rangePresent;
            List list = ipv4Range = this.ipv4RangeSet ? this.ipv4Range : this.parentMessage.ipv4Range;
            if (ipv4Range == null) {
                throw new NullPointerException("Property ipv4Range must not be null");
            }
            List list2 = ipv6Range = this.ipv6RangeSet ? this.ipv6Range : this.parentMessage.ipv6Range;
            if (ipv6Range == null) {
                throw new NullPointerException("Property ipv6Range must not be null");
            }
            List list3 = portRange = this.portRangeSet ? this.portRange : this.parentMessage.portRange;
            if (portRange == null) {
                throw new NullPointerException("Property portRange must not be null");
            }
            List list4 = pad = this.padSet ? this.pad : this.parentMessage.pad;
            if (pad == null) {
                throw new NullPointerException("Property pad must not be null");
            }
            return new OFActionNiciraNatVer12(flags, rangePresent, ipv4Range, ipv6Range, portRange, pad);
        }
    }
}

