/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraLoad;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionNiciraLoadVer12
implements OFActionNiciraLoad {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraLoadVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 24;
    private static final int DEFAULT_OFS_NBITS = 0;
    private static final long DEFAULT_DST = 0L;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final int ofsNbits;
    private final long dst;
    private final U64 value;
    static final OFActionNiciraLoadVer12 DEFAULT = new OFActionNiciraLoadVer12(0, 0L, DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFActionNiciraLoadVer12Funnel FUNNEL = new OFActionNiciraLoadVer12Funnel();
    static final Writer WRITER = new Writer();

    OFActionNiciraLoadVer12(int ofsNbits, long dst, U64 value) {
        if (value == null) {
            throw new NullPointerException("OFActionNiciraLoadVer12: property value cannot be null");
        }
        this.ofsNbits = ofsNbits;
        this.dst = dst;
        this.value = value;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 7;
    }

    @Override
    public int getOfsNbits() {
        return this.ofsNbits;
    }

    @Override
    public long getDst() {
        return this.dst;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFActionNiciraLoad.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraLoadVer12(");
        b.append("ofsNbits=").append(this.ofsNbits);
        b.append(", ");
        b.append("dst=").append(this.dst);
        b.append(", ");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionNiciraLoadVer12 other = (OFActionNiciraLoadVer12)obj;
        if (this.ofsNbits != other.ofsNbits) {
            return false;
        }
        if (this.dst != other.dst) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.ofsNbits;
        result = 31 * (int)(this.dst ^ this.dst >>> 32);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionNiciraLoadVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionNiciraLoadVer12 message) {
            bb.writeShort(-1);
            bb.writeShort(24);
            bb.writeInt(8992);
            bb.writeShort(7);
            bb.writeShort((int)U16.t(message.ofsNbits));
            bb.writeInt(U32.t(message.dst));
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFActionNiciraLoadVer12Funnel
    implements Funnel<OFActionNiciraLoadVer12> {
        private static final long serialVersionUID = 1L;

        OFActionNiciraLoadVer12Funnel() {
        }

        public void funnel(OFActionNiciraLoadVer12 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)24);
            sink.putInt(8992);
            sink.putShort((short)7);
            sink.putInt(message.ofsNbits);
            sink.putLong(message.dst);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionNiciraLoad> {
        Reader() {
        }

        @Override
        public OFActionNiciraLoad readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 7) {
                throw new OFParseError("Wrong subtype: Expected=0x7(0x7), got=" + subtype);
            }
            int ofsNbits = U16.f(bb.readShort());
            long dst = U32.f(bb.readInt());
            U64 value = U64.ofRaw(bb.readLong());
            OFActionNiciraLoadVer12 actionNiciraLoadVer12 = new OFActionNiciraLoadVer12(ofsNbits, dst, value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionNiciraLoadVer12);
            }
            return actionNiciraLoadVer12;
        }
    }

    static class Builder
    implements OFActionNiciraLoad.Builder {
        private boolean ofsNbitsSet;
        private int ofsNbits;
        private boolean dstSet;
        private long dst;
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 7;
        }

        @Override
        public int getOfsNbits() {
            return this.ofsNbits;
        }

        @Override
        public OFActionNiciraLoad.Builder setOfsNbits(int ofsNbits) {
            this.ofsNbits = ofsNbits;
            this.ofsNbitsSet = true;
            return this;
        }

        @Override
        public long getDst() {
            return this.dst;
        }

        @Override
        public OFActionNiciraLoad.Builder setDst(long dst) {
            this.dst = dst;
            this.dstSet = true;
            return this;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFActionNiciraLoad.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFActionNiciraLoad build() {
            U64 value;
            int ofsNbits = this.ofsNbitsSet ? this.ofsNbits : 0;
            long dst = this.dstSet ? this.dst : 0L;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFActionNiciraLoadVer12(ofsNbits, dst, value);
        }
    }

    static class BuilderWithParent
    implements OFActionNiciraLoad.Builder {
        final OFActionNiciraLoadVer12 parentMessage;
        private boolean ofsNbitsSet;
        private int ofsNbits;
        private boolean dstSet;
        private long dst;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFActionNiciraLoadVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 7;
        }

        @Override
        public int getOfsNbits() {
            return this.ofsNbits;
        }

        @Override
        public OFActionNiciraLoad.Builder setOfsNbits(int ofsNbits) {
            this.ofsNbits = ofsNbits;
            this.ofsNbitsSet = true;
            return this;
        }

        @Override
        public long getDst() {
            return this.dst;
        }

        @Override
        public OFActionNiciraLoad.Builder setDst(long dst) {
            this.dst = dst;
            this.dstSet = true;
            return this;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFActionNiciraLoad.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFActionNiciraLoad build() {
            U64 value;
            int ofsNbits = this.ofsNbitsSet ? this.ofsNbits : this.parentMessage.ofsNbits;
            long dst = this.dstSet ? this.dst : this.parentMessage.dst;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFActionNiciraLoadVer12(ofsNbits, dst, value);
        }
    }
}

