/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraCtClear;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionNiciraCtClearVer12
implements OFActionNiciraCtClear {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraCtClearVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 16;
    static final OFActionNiciraCtClearVer12 DEFAULT = new OFActionNiciraCtClearVer12();
    static final OFActionNiciraCtClearVer12 INSTANCE = new OFActionNiciraCtClearVer12();
    static final Reader READER = new Reader();
    static final OFActionNiciraCtClearVer12Funnel FUNNEL = new OFActionNiciraCtClearVer12Funnel();
    static final Writer WRITER = new Writer();

    private OFActionNiciraCtClearVer12() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 43;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFActionNiciraCtClear.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionNiciraCtClearVer12 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraCtClearVer12(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionNiciraCtClearVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionNiciraCtClearVer12 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(8992);
            bb.writeShort(43);
            bb.writeZero(6);
        }
    }

    static class OFActionNiciraCtClearVer12Funnel
    implements Funnel<OFActionNiciraCtClearVer12> {
        private static final long serialVersionUID = 1L;

        OFActionNiciraCtClearVer12Funnel() {
        }

        public void funnel(OFActionNiciraCtClearVer12 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(8992);
            sink.putShort((short)43);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionNiciraCtClear> {
        Reader() {
        }

        @Override
        public OFActionNiciraCtClear readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 43) {
                throw new OFParseError("Wrong subtype: Expected=0x2b(0x2b), got=" + subtype);
            }
            bb.skipBytes(6);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

