/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.ver11.OFAggregateStatsReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFDescStatsReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFExperimenterStatsReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFFlowStatsReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFGroupDescStatsReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFGroupStatsReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFPortStatsReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFQueueStatsReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFTableStatsReplyVer11;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFStatsReplyVer11 {
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFStatsReplyVer11() {
    }

    static class Reader
    implements OFMessageReader<OFStatsReply> {
        Reader() {
        }

        @Override
        public OFStatsReply readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            bb.readerIndex(start);
            switch (statsType) {
                case 2: {
                    return OFAggregateStatsReplyVer11.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterStatsReplyVer11.READER.readFrom(bb);
                }
                case 0: {
                    return OFDescStatsReplyVer11.READER.readFrom(bb);
                }
                case 1: {
                    return OFFlowStatsReplyVer11.READER.readFrom(bb);
                }
                case 4: {
                    return OFPortStatsReplyVer11.READER.readFrom(bb);
                }
                case 5: {
                    return OFQueueStatsReplyVer11.READER.readFrom(bb);
                }
                case 3: {
                    return OFTableStatsReplyVer11.READER.readFrom(bb);
                }
                case 7: {
                    return OFGroupDescStatsReplyVer11.READER.readFrom(bb);
                }
                case 6: {
                    return OFGroupStatsReplyVer11.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator statsType of class OFStatsReplyVer11: " + statsType);
        }
    }
}

