/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.PrimitiveSink;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowWildcards;

public class OFFlowWildcardsSerializerVer11 {
    public static final int IN_PORT_VAL = 1;
    public static final int DL_VLAN_VAL = 2;
    public static final int DL_TYPE_VAL = 8;
    public static final int NW_PROTO_VAL = 32;
    public static final int TP_SRC_VAL = 64;
    public static final int TP_DST_VAL = 128;
    public static final int DL_VLAN_PCP_VAL = 4;
    public static final int NW_TOS_VAL = 16;
    public static final int ALL_VAL = 1023;
    public static final int MPLS_LABEL_VAL = 256;
    public static final int MPLS_TC_VAL = 512;

    public static Set<OFFlowWildcards> readFrom(ChannelBuffer bb) throws OFParseError {
        try {
            return OFFlowWildcardsSerializerVer11.ofWireValue(bb.readInt());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ChannelBuffer bb, Set<OFFlowWildcards> set) {
        bb.writeInt(OFFlowWildcardsSerializerVer11.toWireValue(set));
    }

    public static void putTo(Set<OFFlowWildcards> set, PrimitiveSink sink) {
        sink.putInt(OFFlowWildcardsSerializerVer11.toWireValue(set));
    }

    public static Set<OFFlowWildcards> ofWireValue(int val) {
        EnumSet<OFFlowWildcards> set = EnumSet.noneOf(OFFlowWildcards.class);
        if ((val & 1) != 0) {
            set.add(OFFlowWildcards.IN_PORT);
        }
        if ((val & 2) != 0) {
            set.add(OFFlowWildcards.DL_VLAN);
        }
        if ((val & 8) != 0) {
            set.add(OFFlowWildcards.DL_TYPE);
        }
        if ((val & 0x20) != 0) {
            set.add(OFFlowWildcards.NW_PROTO);
        }
        if ((val & 0x40) != 0) {
            set.add(OFFlowWildcards.TP_SRC);
        }
        if ((val & 0x80) != 0) {
            set.add(OFFlowWildcards.TP_DST);
        }
        if ((val & 4) != 0) {
            set.add(OFFlowWildcards.DL_VLAN_PCP);
        }
        if ((val & 0x10) != 0) {
            set.add(OFFlowWildcards.NW_TOS);
        }
        if ((val & 0x3FF) != 0) {
            set.add(OFFlowWildcards.ALL);
        }
        if ((val & 0x100) != 0) {
            set.add(OFFlowWildcards.MPLS_LABEL);
        }
        if ((val & 0x200) != 0) {
            set.add(OFFlowWildcards.MPLS_TC);
        }
        return Collections.unmodifiableSet(set);
    }

    public static int toWireValue(Set<OFFlowWildcards> set) {
        int wireValue = 0;
        block13: for (OFFlowWildcards e : set) {
            switch (e) {
                case IN_PORT: {
                    wireValue |= 1;
                    continue block13;
                }
                case DL_VLAN: {
                    wireValue |= 2;
                    continue block13;
                }
                case DL_TYPE: {
                    wireValue |= 8;
                    continue block13;
                }
                case NW_PROTO: {
                    wireValue |= 0x20;
                    continue block13;
                }
                case TP_SRC: {
                    wireValue |= 0x40;
                    continue block13;
                }
                case TP_DST: {
                    wireValue |= 0x80;
                    continue block13;
                }
                case DL_VLAN_PCP: {
                    wireValue |= 4;
                    continue block13;
                }
                case NW_TOS: {
                    wireValue |= 0x10;
                    continue block13;
                }
                case ALL: {
                    wireValue |= 0x3FF;
                    continue block13;
                }
                case MPLS_LABEL: {
                    wireValue |= 0x100;
                    continue block13;
                }
                case MPLS_TC: {
                    wireValue |= 0x200;
                    continue block13;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFFlowWildcards in version 1.1: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

