/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetVlanPcp;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.VlanPcp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetVlanPcpVer10
implements OFActionSetVlanPcp {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetVlanPcpVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 8;
    private static final VlanPcp DEFAULT_VLAN_PCP = VlanPcp.NONE;
    private final VlanPcp vlanPcp;
    static final OFActionSetVlanPcpVer10 DEFAULT = new OFActionSetVlanPcpVer10(DEFAULT_VLAN_PCP);
    static final Reader READER = new Reader();
    static final OFActionSetVlanPcpVer10Funnel FUNNEL = new OFActionSetVlanPcpVer10Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetVlanPcpVer10(VlanPcp vlanPcp) {
        if (vlanPcp == null) {
            throw new NullPointerException("OFActionSetVlanPcpVer10: property vlanPcp cannot be null");
        }
        this.vlanPcp = vlanPcp;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_VLAN_PCP;
    }

    @Override
    public VlanPcp getVlanPcp() {
        return this.vlanPcp;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFActionSetVlanPcp.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetVlanPcpVer10(");
        b.append("vlanPcp=").append(this.vlanPcp);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetVlanPcpVer10 other = (OFActionSetVlanPcpVer10)obj;
        return !(this.vlanPcp == null ? other.vlanPcp != null : !this.vlanPcp.equals(other.vlanPcp));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vlanPcp == null ? 0 : this.vlanPcp.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetVlanPcpVer10> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionSetVlanPcpVer10 message) {
            bb.writeShort(2);
            bb.writeShort(8);
            message.vlanPcp.writeByte(bb);
            bb.writeZero(3);
        }
    }

    static class OFActionSetVlanPcpVer10Funnel
    implements Funnel<OFActionSetVlanPcpVer10> {
        private static final long serialVersionUID = 1L;

        OFActionSetVlanPcpVer10Funnel() {
        }

        public void funnel(OFActionSetVlanPcpVer10 message, PrimitiveSink sink) {
            sink.putShort((short)2);
            sink.putShort((short)8);
            message.vlanPcp.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetVlanPcp> {
        Reader() {
        }

        @Override
        public OFActionSetVlanPcp readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 2) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_VLAN_PCP(2), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            VlanPcp vlanPcp = VlanPcp.readByte(bb);
            bb.skipBytes(3);
            OFActionSetVlanPcpVer10 actionSetVlanPcpVer10 = new OFActionSetVlanPcpVer10(vlanPcp);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetVlanPcpVer10);
            }
            return actionSetVlanPcpVer10;
        }
    }

    static class Builder
    implements OFActionSetVlanPcp.Builder {
        private boolean vlanPcpSet;
        private VlanPcp vlanPcp;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_VLAN_PCP;
        }

        @Override
        public VlanPcp getVlanPcp() {
            return this.vlanPcp;
        }

        @Override
        public OFActionSetVlanPcp.Builder setVlanPcp(VlanPcp vlanPcp) {
            this.vlanPcp = vlanPcp;
            this.vlanPcpSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionSetVlanPcp build() {
            VlanPcp vlanPcp;
            VlanPcp vlanPcp2 = vlanPcp = this.vlanPcpSet ? this.vlanPcp : DEFAULT_VLAN_PCP;
            if (vlanPcp == null) {
                throw new NullPointerException("Property vlanPcp must not be null");
            }
            return new OFActionSetVlanPcpVer10(vlanPcp);
        }
    }

    static class BuilderWithParent
    implements OFActionSetVlanPcp.Builder {
        final OFActionSetVlanPcpVer10 parentMessage;
        private boolean vlanPcpSet;
        private VlanPcp vlanPcp;

        BuilderWithParent(OFActionSetVlanPcpVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_VLAN_PCP;
        }

        @Override
        public VlanPcp getVlanPcp() {
            return this.vlanPcp;
        }

        @Override
        public OFActionSetVlanPcp.Builder setVlanPcp(VlanPcp vlanPcp) {
            this.vlanPcp = vlanPcp;
            this.vlanPcpSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionSetVlanPcp build() {
            VlanPcp vlanPcp;
            VlanPcp vlanPcp2 = vlanPcp = this.vlanPcpSet ? this.vlanPcp : this.parentMessage.vlanPcp;
            if (vlanPcp == null) {
                throw new NullPointerException("Property vlanPcp must not be null");
            }
            return new OFActionSetVlanPcpVer10(vlanPcp);
        }
    }
}

