/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraResubmit;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionNiciraResubmitVer10
implements OFActionNiciraResubmit {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraResubmitVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 16;
    private static final int DEFAULT_IN_PORT = 0;
    private static final short DEFAULT_TABLE = 0;
    private final int inPort;
    private final short table;
    static final OFActionNiciraResubmitVer10 DEFAULT = new OFActionNiciraResubmitVer10(0, 0);
    static final Reader READER = new Reader();
    static final OFActionNiciraResubmitVer10Funnel FUNNEL = new OFActionNiciraResubmitVer10Funnel();
    static final Writer WRITER = new Writer();

    OFActionNiciraResubmitVer10(int inPort, short table) {
        this.inPort = inPort;
        this.table = table;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 1;
    }

    @Override
    public int getInPort() {
        return this.inPort;
    }

    @Override
    public short getTable() {
        return this.table;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFActionNiciraResubmit.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraResubmitVer10(");
        b.append("inPort=").append(this.inPort);
        b.append(", ");
        b.append("table=").append(this.table);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionNiciraResubmitVer10 other = (OFActionNiciraResubmitVer10)obj;
        if (this.inPort != other.inPort) {
            return false;
        }
        return this.table == other.table;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.inPort;
        result = 31 * result + this.table;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionNiciraResubmitVer10> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionNiciraResubmitVer10 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(8992);
            bb.writeShort(1);
            bb.writeShort((int)U16.t(message.inPort));
            bb.writeByte((int)U8.t(message.table));
            bb.writeZero(3);
        }
    }

    static class OFActionNiciraResubmitVer10Funnel
    implements Funnel<OFActionNiciraResubmitVer10> {
        private static final long serialVersionUID = 1L;

        OFActionNiciraResubmitVer10Funnel() {
        }

        public void funnel(OFActionNiciraResubmitVer10 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(8992);
            sink.putShort((short)1);
            sink.putInt(message.inPort);
            sink.putShort(message.table);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionNiciraResubmit> {
        Reader() {
        }

        @Override
        public OFActionNiciraResubmit readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 1) {
                throw new OFParseError("Wrong subtype: Expected=0x1(0x1), got=" + subtype);
            }
            int inPort = U16.f(bb.readShort());
            short table = U8.f(bb.readByte());
            bb.skipBytes(3);
            OFActionNiciraResubmitVer10 actionNiciraResubmitVer10 = new OFActionNiciraResubmitVer10(inPort, table);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionNiciraResubmitVer10);
            }
            return actionNiciraResubmitVer10;
        }
    }

    static class Builder
    implements OFActionNiciraResubmit.Builder {
        private boolean inPortSet;
        private int inPort;
        private boolean tableSet;
        private short table;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 1;
        }

        @Override
        public int getInPort() {
            return this.inPort;
        }

        @Override
        public OFActionNiciraResubmit.Builder setInPort(int inPort) {
            this.inPort = inPort;
            this.inPortSet = true;
            return this;
        }

        @Override
        public short getTable() {
            return this.table;
        }

        @Override
        public OFActionNiciraResubmit.Builder setTable(short table) {
            this.table = table;
            this.tableSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionNiciraResubmit build() {
            int inPort = this.inPortSet ? this.inPort : 0;
            short table = this.tableSet ? this.table : (short)0;
            return new OFActionNiciraResubmitVer10(inPort, table);
        }
    }

    static class BuilderWithParent
    implements OFActionNiciraResubmit.Builder {
        final OFActionNiciraResubmitVer10 parentMessage;
        private boolean inPortSet;
        private int inPort;
        private boolean tableSet;
        private short table;

        BuilderWithParent(OFActionNiciraResubmitVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public int getSubtype() {
            return 1;
        }

        @Override
        public int getInPort() {
            return this.inPort;
        }

        @Override
        public OFActionNiciraResubmit.Builder setInPort(int inPort) {
            this.inPort = inPort;
            this.inPortSet = true;
            return this;
        }

        @Override
        public short getTable() {
            return this.table;
        }

        @Override
        public OFActionNiciraResubmit.Builder setTable(short table) {
            this.table = table;
            this.tableSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionNiciraResubmit build() {
            int inPort = this.inPortSet ? this.inPort : this.parentMessage.inPort;
            short table = this.tableSet ? this.table : this.parentMessage.table;
            return new OFActionNiciraResubmitVer10(inPort, table);
        }
    }
}

