/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.netcfghost;

import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.BasicHostConfig;
import org.onosproject.net.host.DefaultHostDescription;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class NetworkConfigHostProvider
extends AbstractProvider
implements HostProvider {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry networkConfigRegistry;
    private ApplicationId appId;
    private static final String APP_NAME = "org.onosproject.netcfghost";
    private static final ProviderId PROVIDER_ID = new ProviderId("host", "org.onosproject.netcfghost");
    protected HostProviderService providerService;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final InternalNetworkConfigListener networkConfigListener = new InternalNetworkConfigListener();

    public NetworkConfigHostProvider() {
        super(PROVIDER_ID);
    }

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.providerService = (HostProviderService)this.providerRegistry.register((Provider)this);
        this.networkConfigRegistry.addListener((EventListener)this.networkConfigListener);
        this.readInitialConfig();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.networkConfigRegistry.removeListener((EventListener)this.networkConfigListener);
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        this.log.info("Stopped");
    }

    public void triggerProbe(Host host) {
    }

    protected void addHost(MacAddress mac, VlanId vlan, HostLocation hloc, Set<IpAddress> ips) {
        HostId hid = HostId.hostId((MacAddress)mac, (VlanId)vlan);
        DefaultHostDescription desc = ips != null ? new DefaultHostDescription(mac, vlan, hloc, ips, true, new SparseAnnotations[0]) : new DefaultHostDescription(mac, vlan, hloc, true, new SparseAnnotations[0]);
        this.providerService.hostDetected(hid, (HostDescription)desc, true);
    }

    protected void updateHost(MacAddress mac, VlanId vlan, HostLocation hloc, Set<IpAddress> ips) {
        HostId hid = HostId.hostId((MacAddress)mac, (VlanId)vlan);
        DefaultHostDescription desc = new DefaultHostDescription(mac, vlan, hloc, ips, true, new SparseAnnotations[0]);
        this.providerService.hostDetected(hid, (HostDescription)desc, true);
    }

    protected void removeHost(MacAddress mac, VlanId vlan) {
        HostId hid = HostId.hostId((MacAddress)mac, (VlanId)vlan);
        this.providerService.hostVanished(hid);
    }

    private void readInitialConfig() {
        this.networkConfigRegistry.getSubjects(HostId.class).forEach(hostId -> {
            MacAddress mac = hostId.mac();
            VlanId vlan = hostId.vlanId();
            BasicHostConfig hostConfig = (BasicHostConfig)this.networkConfigRegistry.getConfig(hostId, BasicHostConfig.class);
            Set ipAddresses = hostConfig.ipAddresses();
            ConnectPoint location = hostConfig.location();
            HostLocation hloc = new HostLocation(location, System.currentTimeMillis());
            this.addHost(mac, vlan, hloc, ipAddresses);
        });
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        this.providerRegistry = hostProviderRegistry;
    }

    protected void unbindProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        if (this.providerRegistry == hostProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindNetworkConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.networkConfigRegistry = networkConfigRegistry;
    }

    protected void unbindNetworkConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.networkConfigRegistry == networkConfigRegistry) {
            this.networkConfigRegistry = null;
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (!event.configClass().equals(BasicHostConfig.class) || event.type() == NetworkConfigEvent.Type.CONFIG_REGISTERED || event.type() == NetworkConfigEvent.Type.CONFIG_UNREGISTERED) {
                return;
            }
            HostId hostId = (HostId)event.subject();
            MacAddress mac = hostId.mac();
            VlanId vlan = hostId.vlanId();
            BasicHostConfig hostConfig = (BasicHostConfig)NetworkConfigHostProvider.this.networkConfigRegistry.getConfig((Object)hostId, BasicHostConfig.class);
            Set ipAddresses = null;
            HostLocation hloc = null;
            if (hostConfig != null) {
                ipAddresses = hostConfig.ipAddresses();
                ConnectPoint location = hostConfig.location();
                hloc = new HostLocation(location, System.currentTimeMillis());
            }
            switch ((NetworkConfigEvent.Type)event.type()) {
                case CONFIG_ADDED: {
                    NetworkConfigHostProvider.this.addHost(mac, vlan, hloc, ipAddresses);
                    break;
                }
                case CONFIG_UPDATED: {
                    NetworkConfigHostProvider.this.updateHost(mac, vlan, hloc, ipAddresses);
                    break;
                }
                case CONFIG_REMOVED: {
                    NetworkConfigHostProvider.this.removeHost(mac, vlan);
                    break;
                }
            }
        }
    }
}

