/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.utils;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.onosproject.yangutils.datamodel.RpcNotificationContainer;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangChoice;
import org.onosproject.yangutils.datamodel.YangDataStructure;
import org.onosproject.yangutils.datamodel.YangLeafRef;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.utils.IndentationType;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGeneratorUtils;
import org.onosproject.yangutils.translator.tojava.utils.MethodClassTypes;
import org.onosproject.yangutils.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yangutils.translator.tojava.utils.StringGenerator;
import org.onosproject.yangutils.translator.tojava.utils.TranslatorUtils;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public final class SubtreeFilteringMethodsGenerator {
    private SubtreeFilteringMethodsGenerator() {
    }

    static String getProcessSubTreeForChoiceInterface(YangNode node) {
        if (!(node instanceof YangChoice)) {
            throw new TranslatorException("process sub tree for interface is only allowed in choice node.");
        }
        JavaFileInfoTranslator info = ((JavaCodeGeneratorInfo)node).getJavaFileInfo();
        String name = info.getJavaName();
        String returnType = YangIoUtils.getCapitalCase(name);
        String javadoc = "\n   /**\n     * Applications need not to implement process subtree of " + name + "\n     * it will be overridden by " + "corresponding case class.\n" + "     *\n" + "     * @param " + "appInstance" + " " + "appInstance" + " " + "being passed to check" + " for" + " content match\n" + "     * @param isSelectAllSchemaChild is select all schema child\n" + "     * @return match result\n" + "     */\n";
        StringBuilder builder = new StringBuilder(javadoc);
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put("appInstance", returnType);
        param.put("isSelectAllSchemaChild", "boolean");
        builder.append(StringGenerator.multiAttrMethodSignature("processSubtreeFiltering", null, "default", returnType, param, MethodClassTypes.CLASS_TYPE)).append(StringGenerator.getReturnString("null", "        ")).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return builder.toString();
    }

    public static String getSubtreeFilteringForLeaf(JavaAttributeInfo javaAttributeInfo, YangType<?> type) {
        String attributeName = javaAttributeInfo.getAttributeName();
        String attrQualifiedType = SubtreeFilteringMethodsGenerator.getIfFilterContentMatchMethodImpl(attributeName, type);
        String condition = "isSubTreeFiltered && !appInstance.isLeafValueSet" + StringGenerator.getOpenCloseParaWithValue("LeafIdentifier." + attributeName.toUpperCase());
        return StringGenerator.getIfConditionBegin("        ", StringGenerator.getLeafFlagSetString(attributeName, "valueLeafFlags", "", "get")) + StringGenerator.getIfConditionBegin("            ", attrQualifiedType) + StringGenerator.getIfConditionBegin("                ", condition) + "                    " + "subTreeFilteringResultBuilder" + "." + attributeName + StringGenerator.getOpenCloseParaWithValue(attributeName + "()") + StringGenerator.signatureClose() + "                " + "}" + " else " + "{" + "\n" + StringGenerator.getReturnString("false", "                    ") + StringGenerator.signatureClose() + "                " + "}" + "\n" + "            " + "}" + " else " + "{" + "\n" + SubtreeFilteringMethodsGenerator.getSubTreeBuilderCallString("                ", attributeName, IndentationType.TWELVE_SPACE) + StringGenerator.getElseIfConditionBegin("        ", StringGenerator.getLeafFlagSetString(attributeName, "selectLeafFlags", "", "get") + " " + "||" + " " + "isSelectAllSchemaChild") + SubtreeFilteringMethodsGenerator.getSelectOrContainmentAssignString() + SubtreeFilteringMethodsGenerator.getSubTreeBuilderCallString("            ", attributeName, IndentationType.EIGHT_SPACE);
    }

    private static String getSubTreeBuilderCallString(String indent, String name, IndentationType type) {
        return indent + "subTreeFilteringResultBuilder" + "." + name + StringGenerator.getOpenCloseParaWithValue("appInstance." + name + "()") + StringGenerator.signatureClose() + StringGenerator.methodClose(type);
    }

    private static String getAttrTypeForFcmWhenPrimitiveDataType(String attributeName) {
        return "appInstance." + attributeName + "(" + ")" + " " + "!" + "=" + " " + attributeName + "(" + ")";
    }

    private static String attrTypeForFcmWhenNonPrimitiveDataTypes(String name) {
        return StringGenerator.getEqualEqualString(StringGenerator.getAppInstanceAttrString(name), "null") + " " + "||" + " " + "!" + "(" + StringGenerator.getTwoParaEqualsString(name + "()", StringGenerator.getAppInstanceAttrString(name)) + ")";
    }

    private static String getIfFilterContentMatchMethodImpl(String name, YangType dataType) {
        YangType type;
        String attrQualifiedType = dataType.getDataType().isPrimitiveDataType() ? SubtreeFilteringMethodsGenerator.getAttrTypeForFcmWhenPrimitiveDataType(name) : (dataType.getDataType() == YangDataTypes.LEAFREF ? (((YangLeafRef)dataType.getDataTypeExtendedInfo()).isInGrouping() ? SubtreeFilteringMethodsGenerator.attrTypeForFcmWhenNonPrimitiveDataTypes(name) : ((type = ((YangLeafRef)dataType.getDataTypeExtendedInfo()).getEffectiveDataType()).getDataType().isPrimitiveDataType() ? SubtreeFilteringMethodsGenerator.getAttrTypeForFcmWhenPrimitiveDataType(name) : SubtreeFilteringMethodsGenerator.attrTypeForFcmWhenNonPrimitiveDataTypes(name))) : SubtreeFilteringMethodsGenerator.attrTypeForFcmWhenNonPrimitiveDataTypes(name));
        return attrQualifiedType;
    }

    public static String getSubtreeFilteringForLeafList(JavaAttributeInfo javaAttributeInfo) {
        return SubtreeFilteringMethodsGenerator.getSubtreeFilteringForList(javaAttributeInfo, true, null);
    }

    static String getProcessChildNodeSubtreeFiltering(YangNode curNode, String path) throws IOException {
        return SubtreeFilteringMethodsGenerator.getProcessStfMethods("processChildNodesSubTreeFiltering", curNode, path, 0x2000000);
    }

    static String getProcessLeafListSubtreeFiltering(YangNode curNode, String path) throws IOException {
        return SubtreeFilteringMethodsGenerator.getProcessStfMethods("processLeafListSubTreeFiltering", curNode, path, 0x1000000);
    }

    static String getProcessLeafSubtreeFiltering(YangNode curNode, String path) throws IOException {
        return SubtreeFilteringMethodsGenerator.getProcessStfMethods("processLeafSubtreeFiltering", curNode, path, 0x800000);
    }

    static String getProcessSubtreeFilteringStart(YangNode curNode) {
        StringBuilder builder = new StringBuilder();
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        String instance = "appInstance";
        String name = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        String builderNamePrefix = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        String caseName = SubtreeFilteringMethodsGenerator.getNameOfClassForIfCase(curNode);
        String returnType = curNode instanceof RpcNotificationContainer ? name + "OpParam" : "Default" + name;
        if (caseName != null) {
            instance = "instance";
            name = caseName;
        }
        String javadoc = "\n    /**\n     * Checks if the passed " + name + " maps the content " + "match query condition.\n" + "     *\n" + "     * @param " + instance + " " + instance + " " + "being passed to check for content match\n" + "     * @param isSelectAllSchemaChild is select all schema " + "child\n" + "     * @return match result\n" + "     */\n";
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put(instance, name);
        param.put("isSelectAllSchemaChild", "boolean");
        builder.append(javadoc).append(StringGenerator.multiAttrMethodSignature("processSubtreeFiltering", null, "public", returnType, param, MethodClassTypes.CLASS_TYPE));
        builder.append(StringGenerator.getNewInstance(builderNamePrefix + "Builder", "subTreeFilteringResultBuilder", "        ", ""));
        builder.append(StringGenerator.getNewInstance("BitSet", "isAnySelectOrContainmentNode", "        ", ""));
        if (caseName != null) {
            builder.append(SubtreeFilteringMethodsGenerator.getCaseCastString(javaFileInfo, instance, curNode));
        }
        return builder.toString();
    }

    private static String getProcessStfMethods(String methodName, YangNode curNode, String path, int file) throws IOException {
        StringBuilder builder = new StringBuilder("");
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        String instance = "appInstance";
        String name = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        String builderNamePrefix = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        String caseName = SubtreeFilteringMethodsGenerator.getNameOfClassForIfCase(curNode);
        if (caseName != null) {
            instance = "instance";
            name = caseName;
        }
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put(instance, name);
        param.put("subTreeFilteringResultBuilder", builderNamePrefix + "Builder");
        param.put("isAnySelectOrContainmentNode", "BitSet");
        param.put("isSelectAllSchemaChild", "boolean");
        builder.append(StringGenerator.multiAttrMethodSignature(methodName, null, "private", "boolean", param, MethodClassTypes.CLASS_TYPE));
        if (caseName != null) {
            builder.append(SubtreeFilteringMethodsGenerator.getCaseCastString(javaFileInfo, instance, curNode));
        }
        builder.append(JavaFileGeneratorUtils.getDataFromTempFileHandle(file, TranslatorUtils.getBeanFiles(curNode), path)).append(StringGenerator.getReturnString("true", "        ")).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE)).append("\n");
        return builder.toString();
    }

    static String getProcessSubtreeFunctionBody(YangNode curNode) {
        StringBuilder builder = new StringBuilder();
        if (curNode instanceof YangLeavesHolder) {
            YangLeavesHolder holder = (YangLeavesHolder)curNode;
            if (!holder.getListOfLeaf().isEmpty()) {
                builder.append(SubtreeFilteringMethodsGenerator.getInnerStfMethodClass("processLeafSubtreeFiltering"));
            }
            if (!holder.getListOfLeafList().isEmpty()) {
                builder.append(SubtreeFilteringMethodsGenerator.getInnerStfMethodClass("processLeafListSubTreeFiltering"));
            }
        }
        if (curNode.getChild() != null) {
            builder.append(SubtreeFilteringMethodsGenerator.getInnerStfMethodClass("processChildNodesSubTreeFiltering"));
        }
        return builder.toString();
    }

    private static String getInnerStfMethodClass(String name) {
        StringBuilder builder = new StringBuilder().append(StringGenerator.getIfConditionBegin("        ", SubtreeFilteringMethodsGenerator.getMethodCallsConditionsForStfMethods(name))).append(StringGenerator.getReturnString("null", "            ")).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.EIGHT_SPACE));
        return builder.toString();
    }

    private static String getMethodCallsConditionsForStfMethods(String name) {
        return "!" + name + StringGenerator.getOpenCloseParaWithValue(SubtreeFilteringMethodsGenerator.getConditionString());
    }

    private static String getConditionString() {
        return "appInstance, subTreeFilteringResultBuilder, isAnySelectOrContainmentNode, isSelectAllSchemaChild";
    }

    public static String getSubtreeFilteringForNode(JavaAttributeInfo attr, YangNode node) {
        boolean isList = attr.isListAttr();
        if (isList) {
            return SubtreeFilteringMethodsGenerator.getSubtreeFilteringForList(attr, false, node);
        }
        return SubtreeFilteringMethodsGenerator.getSubtreeFilteringForChildNode(attr, node);
    }

    static String getProcessSubTreeFilteringEnd(String name) {
        StringBuilder builder = new StringBuilder();
        String cond1 = "!isSelectAllSchemaChild && !isAnySelectOrContainmentNode.get" + StringGenerator.getOpenCloseParaWithValue("0");
        String call = "processSubtreeFiltering" + StringGenerator.getOpenCloseParaWithValue("appInstance, true");
        builder.append(StringGenerator.getIfConditionBegin("        ", cond1)).append(StringGenerator.getReturnString(call, "            ")).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.EIGHT_SPACE));
        call = StringGenerator.getOpenCloseParaWithValue(name) + " " + "subTreeFilteringResultBuilder" + "." + "buildForFilter" + "()";
        builder.append(StringGenerator.getReturnString(call, "        ")).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE)).append("\n");
        return builder.toString();
    }

    private static String getSubtreeFilteringForChildNode(JavaAttributeInfo attr, YangNode node) {
        StringBuilder builder = new StringBuilder();
        String name = attr.getAttributeName();
        String clsInfo = attr.getImportInfo().getClassInfo();
        String type = "Default" + attr.getImportInfo().getClassInfo();
        if (attr.isQualifiedName()) {
            type = attr.getImportInfo().getPkgInfo() + "." + type;
            clsInfo = attr.getImportInfo().getPkgInfo() + "." + clsInfo;
        }
        String classCast = StringGenerator.getOpenCloseParaWithValue(type) + " ";
        String cast = StringGenerator.getOpenCloseParaWithValue(classCast + name);
        if (node != null && node instanceof YangChoice) {
            cast = name;
        }
        String resultString = cast + "\n" + "                            " + "." + "processSubtreeFiltering" + "(" + "appInstance" + "." + name + "()" + "," + " " + "false" + ")" + ";" + "\n";
        String cond1 = name + "()" + " " + "!" + "=" + " " + "null" + " " + "||" + " " + "isSelectAllSchemaChild";
        builder.append(StringGenerator.getIfConditionBegin("        ", cond1)).append(SubtreeFilteringMethodsGenerator.getSelectOrContainmentAssignString());
        builder.append(StringGenerator.getIfConditionBegin("            ", SubtreeFilteringMethodsGenerator.getAppInstanceCondition(name, "!")));
        String assignment = "                " + clsInfo + " " + "result" + " " + "=" + " " + "null" + StringGenerator.signatureClose();
        builder.append(assignment).append(StringGenerator.getIfConditionBegin("                ", "isSelectAllSchemaChild"));
        assignment = SubtreeFilteringMethodsGenerator.getDummyObjectCreation(node, name, clsInfo, type, classCast, false, false);
        builder.append(assignment).append("                ").append("}").append(" else ").append("{").append("\n");
        assignment = "                    result = " + resultString;
        cond1 = "result != null";
        builder.append(assignment).append(StringGenerator.methodClose(IndentationType.SIXTEEN_SPACE)).append(StringGenerator.getIfConditionBegin("                ", cond1));
        assignment = "                    subTreeFilteringResultBuilder." + name + StringGenerator.getOpenCloseParaWithValue("result") + StringGenerator.signatureClose();
        builder.append(assignment).append(StringGenerator.methodClose(IndentationType.SIXTEEN_SPACE)).append("            ").append("}").append(SubtreeFilteringMethodsGenerator.getSubTreeFilteredCondition(name)).append(StringGenerator.methodClose(IndentationType.EIGHT_SPACE));
        return builder.toString();
    }

    private static String getAppInstanceCondition(String name, String condition) {
        return "appInstance." + name + "()" + " " + condition + "=" + " " + "null";
    }

    private static String getSelectOrContainmentAssignString() {
        return "            isAnySelectOrContainmentNode.set" + StringGenerator.getOpenCloseParaWithValue("0") + StringGenerator.signatureClose();
    }

    private static String getSubtreeFilteringForList(JavaAttributeInfo javaAttributeInfo, boolean isLeafList, YangNode node) {
        String assignment;
        String para;
        String mapEntry;
        String forCondition;
        StringBuilder builder = new StringBuilder();
        String caps = YangIoUtils.getCapitalCase(javaAttributeInfo.getAttributeName());
        String name = javaAttributeInfo.getAttributeName();
        String type = javaAttributeInfo.getImportInfo().getClassInfo();
        if (javaAttributeInfo.getAttributeType() != null && javaAttributeInfo.getAttributeType().getDataType() == YangDataTypes.IDENTITYREF) {
            type = "Class<? extends " + type + ">";
        }
        YangDataStructure struct = MethodsGenerator.getYangDataStructure(javaAttributeInfo.getCompilerAnnotation());
        boolean isMap = false;
        if (struct != null && struct == YangDataStructure.MAP) {
            isMap = true;
        }
        String clsInfo = "Default" + type;
        if (javaAttributeInfo.isQualifiedName()) {
            type = javaAttributeInfo.getAttributeType() != null && javaAttributeInfo.getAttributeType().getDataType() == YangDataTypes.IDENTITYREF ? "Class<? extends " + javaAttributeInfo.getImportInfo().getPkgInfo() + "." + type + ">" : javaAttributeInfo.getImportInfo().getPkgInfo() + "." + type;
            clsInfo = javaAttributeInfo.getImportInfo().getPkgInfo() + "." + clsInfo;
        }
        String classCast = StringGenerator.getOpenCloseParaWithValue(clsInfo) + " ";
        String cast = StringGenerator.getOpenCloseParaWithValue(classCast + name);
        if (node != null && node instanceof YangChoice) {
            cast = name;
        }
        String validPass = isMap ? name + "2" + "." + "getValue()" : name + "2";
        String resultString = cast + "\n" + "                            " + "." + "processSubtreeFiltering" + "(" + validPass + "," + " " + "false" + ")" + ";" + "\n";
        if (!isMap) {
            forCondition = StringGenerator.getForLoopString("                ", type, name, StringGenerator.getAppInstanceAttrString(name));
        } else {
            mapEntry = "Map.Entry<" + type + "Keys" + "," + " " + type + ">" + " ";
            para = StringGenerator.getAppInstanceAttrString(name) + "." + "entrySet()";
            forCondition = StringGenerator.getForLoopString("                ", mapEntry, name, para);
        }
        builder.append(StringGenerator.getIfConditionBegin("        ", "isSelectAllSchemaChild")).append(StringGenerator.getIfConditionBegin("            ", SubtreeFilteringMethodsGenerator.getAppInstanceCondition(name, "!"))).append(forCondition);
        String result = isMap ? StringGenerator.getOpenCloseParaWithValue(name + "." + "getKey()" + "," + " " + "result") : StringGenerator.getOpenCloseParaWithValue("result");
        if (!isLeafList) {
            builder.append("                    ").append(type).append(" ").append("result").append(StringGenerator.signatureClose());
            assignment = SubtreeFilteringMethodsGenerator.getDummyObjectCreation(node, name, type, clsInfo, classCast, true, isMap);
            builder.append(assignment);
            assignment = "                    subTreeFilteringResultBuilder.add" + YangIoUtils.getCapitalCase("to") + caps + result + StringGenerator.signatureClose();
            builder.append(assignment);
        } else {
            assignment = "                    subTreeFilteringResultBuilder.add" + YangIoUtils.getCapitalCase("to") + caps + StringGenerator.getOpenCloseParaWithValue(name) + StringGenerator.signatureClose();
            builder.append(assignment);
        }
        builder.append(StringGenerator.methodClose(IndentationType.SIXTEEN_SPACE)).append("            ").append("}");
        builder.append(SubtreeFilteringMethodsGenerator.getSubTreeFilteredCondition(name));
        String cond = name + "()" + " " + "!" + "=" + " " + "null";
        builder.append(StringGenerator.getElseIfConditionBegin("        ", cond));
        if (!isLeafList) {
            builder.append(SubtreeFilteringMethodsGenerator.getSelectOrContainmentAssignString());
        }
        cond = "!" + name + "()" + "." + "isEmpty()";
        builder.append(StringGenerator.getIfConditionBegin("            ", cond));
        if (isLeafList) {
            cond = SubtreeFilteringMethodsGenerator.getAppInstanceCondition(name, "=") + " " + "||" + " " + "appInstance" + "." + name + "()" + "." + "isEmpty()";
            builder.append(StringGenerator.getIfConditionBegin("                ", cond)).append(StringGenerator.getReturnString("false", "                    ")).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.SIXTEEN_SPACE)).append(StringGenerator.getForLoopString("                ", type, name, name + "()"));
            assignment = "                    boolean flag = false" + StringGenerator.signatureClose();
            builder.append(assignment).append(StringGenerator.getForLoopString("                    ", type, name + "2", StringGenerator.getAppInstanceAttrString(name)));
            cond = name + "." + "equals" + "(" + name + "2" + ")";
            builder.append(StringGenerator.getIfConditionBegin("                        ", cond));
            assignment = "                            flag = true;\n";
            builder.append(assignment);
            assignment = "                            subTreeFilteringResultBuilder.add" + YangIoUtils.getCapitalCase("to") + caps + StringGenerator.getOpenCloseParaWithValue(name + "2") + StringGenerator.signatureClose();
            builder.append(assignment).append("                            ").append("break").append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.TWENTY_FOUR_SPACE)).append(StringGenerator.methodClose(IndentationType.TWENTY_SPACE)).append(StringGenerator.getIfConditionBegin("                    ", "!flag")).append(StringGenerator.getReturnString("false", "                        ")).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.TWENTY_SPACE)).append(StringGenerator.methodClose(IndentationType.SIXTEEN_SPACE));
        } else {
            String forCondition2;
            cond = SubtreeFilteringMethodsGenerator.getAppInstanceCondition(name, "!") + " " + "&&" + " " + "!" + StringGenerator.getAppInstanceAttrString(name) + "." + "isEmpty()";
            if (!isMap) {
                forCondition = StringGenerator.getForLoopString("                    ", type, name + "2", StringGenerator.getAppInstanceAttrString(name));
            } else {
                mapEntry = "Map.Entry<" + type + "Keys" + "," + " " + type + ">" + " ";
                para = StringGenerator.getAppInstanceAttrString(name) + "." + "entrySet()";
                forCondition = StringGenerator.getForLoopString("                    ", mapEntry, name + "2", para);
            }
            if (!isMap) {
                forCondition2 = StringGenerator.getForLoopString("                ", type, name, name + "()");
            } else {
                mapEntry = "Map.Entry<" + type + "Keys" + "," + " " + type + ">" + " ";
                para = name + "()" + "." + "entrySet()";
                forCondition2 = StringGenerator.getForLoopString("                ", mapEntry, name, para);
            }
            builder.append(StringGenerator.getIfConditionBegin("                ", cond)).append(forCondition2).append(forCondition);
            assignment = "                            " + type + " " + "result" + " " + "=" + " " + resultString;
            builder.append(assignment);
            cond = "result != null";
            builder.append(StringGenerator.getIfConditionBegin("                            ", cond));
            result = isMap ? StringGenerator.getOpenCloseParaWithValue(name + "2" + "." + "getKey()" + "," + " " + "result") : StringGenerator.getOpenCloseParaWithValue("result");
            assignment = "                                subTreeFilteringResultBuilder.add" + YangIoUtils.getCapitalCase("to") + caps + result + StringGenerator.signatureClose();
            builder.append(assignment).append(StringGenerator.methodClose(IndentationType.TWENTY_EIGHT_SPACE)).append(StringGenerator.methodClose(IndentationType.TWENTY_FOUR_SPACE)).append(StringGenerator.methodClose(IndentationType.TWENTY_SPACE)).append("                ").append("}").append(SubtreeFilteringMethodsGenerator.getSubTreeFilteredCondition(name));
        }
        cond = "            } else {\n";
        builder.append(cond);
        if (isLeafList) {
            builder.append(SubtreeFilteringMethodsGenerator.getSelectOrContainmentAssignString());
        }
        if (!isMap) {
            forCondition = StringGenerator.getForLoopString("                ", type, name, StringGenerator.getAppInstanceAttrString(name));
        } else {
            mapEntry = "Map.Entry<" + type + "Keys" + "," + " " + type + ">" + " ";
            para = StringGenerator.getAppInstanceAttrString(name) + "." + "entrySet()";
            forCondition = StringGenerator.getForLoopString("                ", mapEntry, name, para);
        }
        cond = SubtreeFilteringMethodsGenerator.getAppInstanceCondition(name, "!") + " " + "&&" + " " + "!" + StringGenerator.getAppInstanceAttrString(name) + "." + "isEmpty()";
        builder.append(StringGenerator.getIfConditionBegin("                ", cond)).append(forCondition);
        result = isMap ? StringGenerator.getOpenCloseParaWithValue(name + "." + "getKey()" + "," + " " + name + "." + "getValue()") : StringGenerator.getOpenCloseParaWithValue(name);
        assignment = "                        subTreeFilteringResultBuilder.add" + YangIoUtils.getCapitalCase("to") + caps + result + StringGenerator.signatureClose();
        builder.append(assignment).append(StringGenerator.methodClose(IndentationType.TWENTY_SPACE)).append(StringGenerator.methodClose(IndentationType.SIXTEEN_SPACE)).append(StringGenerator.methodClose(IndentationType.TWELVE_SPACE)).append(StringGenerator.methodClose(IndentationType.EIGHT_SPACE));
        return builder.toString();
    }

    public static String getAugmentableSubTreeFiltering() {
        return "        if (yangAugmentedInfoMap.isEmpty()) {\n            java.util.Set<Map.Entry<Class<?>, Object>> augment = appInstance.yangAugmentedInfoMap().entrySet();\n            if (augment != null && !augment.isEmpty()) {\n                java.util.Iterator<Map.Entry<Class<?>, Object>> augItr = augment.iterator();\n                while (augItr.hasNext()) {\n                    Map.Entry<Class<?>, Object> aug = augItr.next();\n                    Class<?> augClass = aug.getKey();\n                    String augClassName = augClass.getName();\n                    int index = augClassName.lastIndexOf('.');\n                    String classPackage = augClassName.substring(0, index) +\n                            \".\" + \"Default\" + augClass.getSimpleName() + \"$\"\n                            + augClass.getSimpleName() + \"Builder\";\n                    ClassLoader classLoader = augClass.getClassLoader();\n                    try {\n                        Class<?> builderClass;\n                        builderClass = classLoader.loadClass(classPackage);\n                        Object builderObj = builderClass.newInstance();\n                        java.lang.reflect.Method method = builderClass.getMethod(\"build\");\n                        Object defaultObj = method.invoke(builderObj);\n                        Class<?> defaultClass = defaultObj.getClass();\n                        method = defaultClass.getMethod(\"processSubtreeFiltering\", augClass, boolean.class);\n                        Object result = method.invoke(defaultObj, aug.getValue(), true);\n                        subTreeFilteringResultBuilder.addYangAugmentedInfo(result, augClass);\n                    } catch (ClassNotFoundException | InstantiationException\n                            | NoSuchMethodException |\n                            InvocationTargetException | IllegalAccessException e) {\n                    }\n                }\n            }\n        } else {\n            java.util.Set<Map.Entry<Class<?>, Object>> augment = yangAugmentedInfoMap\n                    .entrySet();\n            java.util.Iterator<Map.Entry<Class<?>, Object>> augItr = augment.iterator();\n            while (augItr.hasNext()) {\n                Map.Entry<Class<?>, Object> aug = augItr.next();\n                Class<?> augClass = aug.getKey();\n                Object appInstanceInfo = appInstance.yangAugmentedInfo(augClass);\n                if (appInstanceInfo == null) {\n                    subTreeFilteringResultBuilder.addYangAugmentedInfo(aug.getValue(), aug.getKey());\n                } else {\n                    Object processSubtreeFiltering;\n                    try {\n                        processSubtreeFiltering = aug.getValue().getClass()\n                                .getMethod(\"processSubtreeFiltering\", aug.getKey(), boolean.class)\n                                .invoke(aug.getValue(), appInstanceInfo, true);\n                        if (processSubtreeFiltering != null) {\n                            subTreeFilteringResultBuilder\n                                    .addYangAugmentedInfo(processSubtreeFiltering, aug.getKey());\n                        }\n                    } catch (NoSuchMethodException | InvocationTargetException |\n                            IllegalAccessException e) {\n                    }\n                }\n            }\n        }\n";
    }

    private static String getSubTreeFilteredCondition(String name) {
        StringBuilder builder = new StringBuilder();
        String cond = "isSubTreeFiltered && " + name + "()" + " " + "!" + "=" + " " + "null";
        builder.append(" else ").append("{").append("\n").append(StringGenerator.getIfConditionBegin("                ", cond)).append("                    ").append("subTreeFilteringResultBuilder").append(".").append(name).append(StringGenerator.getOpenCloseParaWithValue(name)).append(StringGenerator.signatureClose()).append("                ").append("}").append("\n").append("            ").append("}").append("\n");
        return builder.toString();
    }

    private static String getNameOfClassForIfCase(YangNode curNode) {
        String name = null;
        if (curNode instanceof YangCase) {
            YangNode parent = curNode.getParent();
            if (parent instanceof YangChoice) {
                JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)parent).getJavaFileInfo();
                name = YangIoUtils.getCapitalCase(parentInfo.getJavaName());
            } else if (parent instanceof YangAugment) {
                JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)((YangAugment)parent).getAugmentedNode()).getJavaFileInfo();
                name = parentInfo != null ? YangIoUtils.getCapitalCase(parentInfo.getJavaName()) : YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(((YangAugment)parent).getAugmentedNode().getName(), null));
            }
        }
        return name;
    }

    private static String getCaseCastString(JavaFileInfoTranslator javaFileInfo, String instance, YangNode curNode) {
        if (curNode instanceof YangCase) {
            String caseName = "Default" + YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
            return "        " + caseName + " " + "appInstance" + " " + "=" + " " + "(" + caseName + ")" + " " + instance + StringGenerator.signatureClose();
        }
        return null;
    }

    private static String getDummyObjectCreation(YangNode node, String name, String clsInfo, String type, String classCast, boolean isList, boolean isMap) {
        String para = StringGenerator.getAppInstanceAttrString(name);
        if (isList) {
            para = isMap ? name + "." + "getValue()" : name;
        }
        if (node != null && node instanceof YangChoice) {
            return SubtreeFilteringMethodsGenerator.getChoiceReflectionResult(name, clsInfo);
        }
        return "                    result = " + StringGenerator.getOpenCloseParaWithValue(classCast + type + "." + "builder" + "()" + "\n" + "                            " + "." + "buildForFilter" + "()") + "." + "processSubtreeFiltering" + StringGenerator.getOpenCloseParaWithValue(para + "," + " " + "true") + StringGenerator.signatureClose();
    }

    private static String getChoiceReflectionResult(String name, String returnType) {
        String call = "appInstance." + name + "()";
        return "                    Class<?>[] classArray = " + call + "" + ".getClass()" + ".getInterfaces();\n" + "                    Class<?> caseIntf = classArray[0];\n" + "                    try {\n" + "                        ClassLoader classLoader = this" + ".getClass().getClassLoader();\n" + "                        String className = \"Default\" + " + "caseIntf.getSimpleName();\n" + "                        className = caseIntf.getPackage()" + ".getName() + \".\" + className;\n" + "                        Class<?> caseClass = classLoader" + ".loadClass(className);\n" + "                        java.lang.reflect.Constructor<?> " + "constructor = caseClass.getDeclaredConstructor();\n" + "                        constructor.setAccessible(true);\n" + "                        Object obj1 = constructor" + ".newInstance();\n" + "                        java.lang.reflect.Method method =" + " caseClass.getMethod(\"builder\");\n" + "                        Object obj = method.invoke(obj1);\n" + "                        Class<?> builderClass = obj.getClass();\n" + "                        method = builderClass.getMethod(\"build\");\n" + "                        Object obj2 = method.invoke(obj);\n" + "                        Class<?> input = this.getClass()" + ".getMethod(" + "\"" + name + "\").getReturnType();\n" + "                        method = caseClass.getMethod" + "(\"processSubtreeFiltering\", input,\n" + "                                     boolean.class);\n" + "                        result = (" + returnType + ") method.invoke" + "(obj2, " + call + ", true);\n" + "                    } catch (NoSuchMethodException | InstantiationException |\n" + "                            IllegalAccessException | " + "InvocationTargetException |\n" + "                            ClassNotFoundException e) {\n" + "                        e.printStackTrace();\n" + "                    }\n";
    }
}

