/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.utils;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangRevision;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.utils.UtilConstants;
import org.onosproject.yangutils.utils.io.YangToJavaNamingConflictUtil;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public final class JavaIdentifierSyntax {
    private static final int INDEX_ZERO = 0;
    private static final int INDEX_ONE = 1;
    private static final int VALUE_CHECK = 10;
    private static final String ZERO = "0";
    private static final String DATE_FORMAT = "yyyy-MM-dd";

    private JavaIdentifierSyntax() {
    }

    public static String getRootPackage(byte version, String nameSpace, YangRevision revision, YangToJavaNamingConflictUtil resolver) {
        StringBuilder pkg = new StringBuilder("org.onosproject.yang.gen").append(".").append(JavaIdentifierSyntax.getYangVersion(version)).append(".").append(JavaIdentifierSyntax.getPkgFromNameSpace(nameSpace, resolver));
        if (revision != null) {
            pkg.append(".").append(JavaIdentifierSyntax.getYangRevisionStr(revision.getRevDate()));
        }
        return pkg.toString().toLowerCase();
    }

    private static String getYangVersion(byte ver) {
        return "v" + ver;
    }

    private static String getPkgFromNameSpace(String nameSpace, YangToJavaNamingConflictUtil resolver) {
        ArrayList<String> pkgArr = new ArrayList<String>();
        nameSpace = nameSpace.replace("\"", "");
        String properNameSpace = nameSpace.replaceAll("\\p{Punct}+", ":");
        String[] nameSpaceArr = properNameSpace.split(":");
        Collections.addAll(pkgArr, nameSpaceArr);
        return JavaIdentifierSyntax.getPkgFrmArr(pkgArr, resolver);
    }

    private static String getYangRevisionStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String dateInString = sdf.format(date);
        String[] revisionArr = dateInString.split("-");
        StringBuilder rev = new StringBuilder("rev").append(revisionArr[0]);
        for (int i = 1; i < revisionArr.length; ++i) {
            Integer val = Integer.parseInt(revisionArr[i]);
            if (val < 10) {
                rev.append(ZERO);
            }
            rev.append(val);
        }
        return rev.toString();
    }

    private static String getPkgFrmArr(ArrayList<String> pkgArr, YangToJavaNamingConflictUtil conflictResolver) {
        StringBuilder pkg = new StringBuilder();
        int size = pkgArr.size();
        int i = 0;
        for (String member : pkgArr) {
            boolean presenceOfKeyword = UtilConstants.JAVA_KEY_WORDS.contains(member.toLowerCase());
            if (presenceOfKeyword || member.matches("\\d.*")) {
                String prefix = YangIoUtils.getPrefixForIdentifier(conflictResolver);
                member = prefix + member;
            }
            pkg.append(member);
            if (i != size - 1) {
                pkg.append(".");
            }
            ++i;
        }
        return pkg.toString();
    }

    public static String getEnumJavaAttribute(String name) {
        name = name.replaceAll("\\p{Punct}+", ":");
        String[] strArray = name.split(":");
        StringBuilder output = new StringBuilder();
        if (strArray[0].isEmpty()) {
            ArrayList<String> stringArrangement = new ArrayList<String>();
            stringArrangement.addAll(Arrays.asList(strArray).subList(1, strArray.length));
            strArray = stringArrangement.toArray(new String[stringArrangement.size()]);
        }
        for (int i = 0; i < strArray.length; ++i) {
            if (i > 0 && i < strArray.length) {
                output.append("_");
            }
            output.append(strArray[i]);
        }
        return output.toString();
    }

    public static void createPackage(YangNode yangNode) throws IOException {
        if (!(yangNode instanceof JavaFileInfoContainer)) {
            throw new TranslatorException("current node must have java file info " + yangNode.getName() + " in " + yangNode.getLineNumber() + " at " + yangNode.getCharPosition() + " in " + yangNode.getFileName());
        }
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)yangNode).getJavaFileInfo();
        String pkg = YangIoUtils.getAbsolutePackagePath(javaFileInfo.getBaseCodeGenPath(), javaFileInfo.getPackageFilePath());
        if (!JavaIdentifierSyntax.doesPackageExist(pkg)) {
            try {
                File pack = YangIoUtils.createDirectories(pkg);
                YangNode parent = DataModelUtils.getParentNodeInGenCode((YangNode)yangNode);
                if (parent != null) {
                    JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)parent).getJavaFileInfo();
                    String pkgInfo = parentInfo.getJavaName();
                    YangIoUtils.addPackageInfo(pack, pkgInfo, YangIoUtils.getJavaPackageFromPackagePath(pkg), true);
                } else {
                    String pkgInfo = javaFileInfo.getJavaName();
                    YangIoUtils.addPackageInfo(pack, pkgInfo, YangIoUtils.getJavaPackageFromPackagePath(pkg), false);
                }
            }
            catch (IOException e) {
                throw new IOException("failed to create package-info file");
            }
        }
    }

    static boolean doesPackageExist(String pkg) {
        File pkgDir = new File(YangIoUtils.getPackageDirPathFromJavaJPackage(pkg));
        File pkgWithFile = new File(pkgDir + UtilConstants.SLASH + "package-info.java");
        return pkgDir.exists() && pkgWithFile.isFile();
    }
}

