/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.javamodel;

import java.io.IOException;
import org.onosproject.yangutils.datamodel.RpcNotificationContainer;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.javadatamodel.YangJavaNotification;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaCodeGenerator;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yangutils.translator.tojava.TempJavaServiceFragmentFiles;
import org.onosproject.yangutils.translator.tojava.YangJavaModelUtils;
import org.onosproject.yangutils.translator.tojava.utils.JavaExtendsListHolder;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.translator.tojava.utils.TranslatorErrorType;
import org.onosproject.yangutils.translator.tojava.utils.TranslatorUtils;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public class YangJavaNotificationTranslator
extends YangJavaNotification
implements JavaCodeGenerator,
JavaCodeGeneratorInfo {
    private static final long serialVersionUID = 806201624L;
    private transient TempJavaCodeFragmentFiles tempFileHandle;

    public YangJavaNotificationTranslator() {
        this.setJavaFileInfo(new JavaFileInfoTranslator());
        this.getJavaFileInfo().setGeneratedFileTypes(8207);
    }

    @Override
    public JavaFileInfoTranslator getJavaFileInfo() {
        if (this.javaFileInfo == null) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.INVALID_NODE, (YangSchemaNode)this));
        }
        return (JavaFileInfoTranslator)this.javaFileInfo;
    }

    @Override
    public void setJavaFileInfo(JavaFileInfoTranslator javaInfo) {
        this.javaFileInfo = javaInfo;
    }

    @Override
    public TempJavaCodeFragmentFiles getTempJavaCodeFragmentFiles() {
        return this.tempFileHandle;
    }

    @Override
    public void setTempJavaCodeFragmentFiles(TempJavaCodeFragmentFiles fileHandle) {
        this.tempFileHandle = fileHandle;
    }

    @Override
    public void generateCodeEntry(YangPluginConfig yangPlugin) throws TranslatorException {
        String enumName = JavaIdentifierSyntax.getEnumJavaAttribute(this.getName().toUpperCase());
        ((RpcNotificationContainer)this.getParent()).addToNotificationEnumMap(enumName, (YangSchemaNode)this);
        try {
            YangJavaModelUtils.generateCodeOfAugmentableNode(this, yangPlugin);
            this.addNotificationToExtendsList();
        }
        catch (IOException e) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.FAIL_AT_ENTRY, (YangSchemaNode)this, e.getLocalizedMessage()));
        }
    }

    private void addNotificationToExtendsList() {
        YangNode parent = this.getParent();
        TempJavaServiceFragmentFiles tempFiles = ((TempJavaCodeFragmentFilesContainer)parent).getTempJavaCodeFragmentFiles().getServiceTempFiles();
        JavaExtendsListHolder holder = tempFiles.getJavaExtendsListHolder();
        JavaQualifiedTypeInfoTranslator event = new JavaQualifiedTypeInfoTranslator();
        String parentInfo = YangIoUtils.getCapitalCase(((JavaFileInfoContainer)parent).getJavaFileInfo().getJavaName());
        event.setClassInfo(parentInfo + "Event");
        event.setPkgInfo(this.getJavaFileInfo().getPackage());
        holder.addToExtendsList(event, parent, tempFiles);
        JavaQualifiedTypeInfoTranslator eventListener = new JavaQualifiedTypeInfoTranslator();
        eventListener.setClassInfo(parentInfo + "EventListener");
        eventListener.setPkgInfo(this.getJavaFileInfo().getPackage());
        holder.addToExtendsList(eventListener, parent, tempFiles);
    }

    @Override
    public void generateCodeExit() throws TranslatorException {
        try {
            this.getTempJavaCodeFragmentFiles().generateJavaFile(8207, (YangNode)this);
        }
        catch (IOException e) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.FAIL_AT_EXIT, (YangSchemaNode)this, e.getLocalizedMessage()));
        }
    }
}

