/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.YangTypeDef;
import org.onosproject.yangutils.datamodel.YangTypeHolder;
import org.onosproject.yangutils.datamodel.YangUnion;
import org.onosproject.yangutils.datamodel.exceptions.ErrorMessages;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaTypeTranslator;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGenerator;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yangutils.translator.tojava.utils.ValidatorTypeForUnionTypes;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.FileSystemUtil;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public class TempJavaTypeFragmentFiles
extends TempJavaFragmentFiles {
    private static final String OF_STRING_METHOD_FILE_NAME = "OfString";
    private static final String CONSTRUCTOR_FOR_TYPE_FILE_NAME = "ConstructorForType";
    private int intIndex = 0;
    private int uIntIndex = 0;
    private int longIndex = 0;
    private int uLongIndex = 0;
    private int shortIndex = 0;
    private int uInt8Index = 0;
    private File ofStringImplTempFileHandle;
    private File constructorForTypeTempFileHandle;
    private File typedefClassJavaFileHandle;
    private File typeClassJavaFileHandle;
    private JavaAttributeInfo intAttribute;
    private JavaAttributeInfo longAttribute;
    private JavaAttributeInfo shortAttribute;
    private JavaAttributeInfo uInt8Attribute;
    private JavaAttributeInfo uIntAttribute;
    private JavaAttributeInfo uLongAttribute;
    private List<YangType<?>> local = new ArrayList();
    private List<JavaAttributeInfo> attrs = new ArrayList<JavaAttributeInfo>();

    TempJavaTypeFragmentFiles(JavaFileInfoTranslator javaFileInfo) throws IOException {
        super(javaFileInfo);
        this.addGeneratedTempFile(3584);
        this.ofStringImplTempFileHandle = this.getTemporaryFileHandle(OF_STRING_METHOD_FILE_NAME);
        this.constructorForTypeTempFileHandle = this.getTemporaryFileHandle(CONSTRUCTOR_FOR_TYPE_FILE_NAME);
    }

    public File getConstructorForTypeTempFileHandle() {
        return this.constructorForTypeTempFileHandle;
    }

    private File getTypedefClassJavaFileHandle() {
        return this.typedefClassJavaFileHandle;
    }

    private void setTypedefClassJavaFileHandle(File typedefClassJavaFileHandle) {
        this.typedefClassJavaFileHandle = typedefClassJavaFileHandle;
    }

    private File getTypeClassJavaFileHandle() {
        return this.typeClassJavaFileHandle;
    }

    private void setTypeClassJavaFileHandle(File typeClassJavaFileHandle) {
        this.typeClassJavaFileHandle = typeClassJavaFileHandle;
    }

    public File getOfStringImplTempFileHandle() {
        return this.ofStringImplTempFileHandle;
    }

    private void verifyUnionTypes(List<YangType<?>> typeList, YangTypeHolder yangTypeHolder) {
        YangUnion union = (YangUnion)yangTypeHolder;
        for (YangType<?> yangType : typeList) {
            String msg;
            YangDataTypes type = yangType.getDataType();
            switch (type) {
                case EMPTY: {
                    msg = "Union member derived type must not be one of the type whose built-in types is \"empty\"";
                    break;
                }
                case LEAFREF: {
                    msg = "Union member derived type must not be one of the type whose built-in types is \"leafref\"";
                    break;
                }
                default: {
                    msg = null;
                }
            }
            if (msg == null) continue;
            throw new TranslatorException(ErrorMessages.getErrorMsg((String)msg, (String)union.getName(), (int)union.getLineNumber(), (int)union.getCharPosition(), (String)union.getFileName()));
        }
    }

    void addTypeInfoToTempFiles(YangTypeHolder yangTypeHolder, YangPluginConfig config) throws IOException {
        List typeList = yangTypeHolder.getTypeList();
        if (yangTypeHolder instanceof YangUnion) {
            this.verifyUnionTypes(typeList, yangTypeHolder);
        }
        if (typeList != null) {
            List<YangType<?>> types = this.validateTypes(typeList);
            for (YangType<?> type : types) {
                if (!(type instanceof YangJavaTypeTranslator)) {
                    throw new TranslatorException("Type does not have Java info " + type.getDataTypeName() + " in " + type.getLineNumber() + " at " + type.getCharPosition() + " in " + type.getFileName());
                }
                JavaAttributeInfo javaAttributeInfo = this.getAttributeForType(type, config);
                if (yangTypeHolder instanceof YangTypeDef) {
                    javaAttributeInfo.setCurHolderOrCount("typedef");
                } else if (types.indexOf(type) == types.size() - 1) {
                    javaAttributeInfo.setCurHolderOrCount("last");
                }
                if (type.getDataType() == YangDataTypes.BITS) {
                    TempJavaTypeFragmentFiles.addBitsHandler(javaAttributeInfo, type, this);
                }
                if (type.getDataType() == YangDataTypes.BINARY) {
                    JavaQualifiedTypeInfoTranslator info = new JavaQualifiedTypeInfoTranslator();
                    info.setClassInfo("Base64");
                    info.setPkgInfo("java.util");
                    this.getJavaImportData().addImportInfo(info, this.getGeneratedJavaClassName(), this.getJavaFileInfo().getPackage());
                }
                this.addJavaSnippetInfoToApplicableTempFiles(javaAttributeInfo, config, types);
            }
            this.addTypeConstructor();
            this.addMethodsInConflictCase(config);
            for (JavaAttributeInfo attr : this.attrs) {
                super.addJavaSnippetInfoToApplicableTempFiles(attr, config);
            }
        }
    }

    private JavaAttributeInfo getAttributeForType(YangType type, YangPluginConfig config) {
        YangJavaTypeTranslator javaType = (YangJavaTypeTranslator)type;
        javaType.updateJavaQualifiedInfo(config.getConflictResolver());
        String typeName = YangIoUtils.getCamelCase(javaType.getDataTypeName(), config.getConflictResolver());
        return JavaAttributeInfo.getAttributeInfoForTheData(javaType.getJavaQualifiedInfo(), typeName, javaType, this.getIsQualifiedAccessOrAddToImportList(javaType.getJavaQualifiedInfo()), false);
    }

    private void addJavaSnippetInfoToApplicableTempFiles(JavaAttributeInfo attr, YangPluginConfig config, List<YangType<?>> types) throws IOException {
        YangDataTypes attrType = attr.getAttributeType().getDataType();
        if (attrType == YangDataTypes.INT16 || attrType == YangDataTypes.UINT8) {
            boolean isShortConflict = this.validateForConflictingShortTypes(types);
            attr.setShortConflict(isShortConflict);
            this.updateAttributeCondition(attr);
            if (!isShortConflict) {
                this.addMethodsWhenNoConflictingTypes(attr, config, types);
            }
        } else if (attrType == YangDataTypes.INT32 || attrType == YangDataTypes.UINT16) {
            boolean isIntConflict = this.validateForConflictingIntTypes(types);
            attr.setIntConflict(isIntConflict);
            this.updateAttributeCondition(attr);
            if (!isIntConflict) {
                this.addMethodsWhenNoConflictingTypes(attr, config, types);
            }
        } else if (attrType == YangDataTypes.INT64 || attrType == YangDataTypes.UINT32) {
            boolean isLongConflict = this.validateForConflictingLongTypes(types);
            attr.setLongConflict(isLongConflict);
            this.updateAttributeCondition(attr);
            if (!isLongConflict) {
                this.addMethodsWhenNoConflictingTypes(attr, config, types);
            }
        } else {
            this.addMethodsWhenNoConflictingTypes(attr, config, types);
        }
        String attrHolder = attr.getCurHolderOrCount();
        if (attrHolder != null && !attrHolder.equals("typedef")) {
            this.attrs.add(attr);
        } else {
            super.addJavaSnippetInfoToApplicableTempFiles(attr, config);
        }
    }

    private List<YangType<?>> validateTypes(List<YangType<?>> types) {
        ArrayList<String> preType = new ArrayList<String>();
        for (YangType<?> type : types) {
            String curType = type.getDataTypeName();
            if (preType.contains(curType)) continue;
            preType.add(curType);
            this.local.add(type);
        }
        return this.local;
    }

    private void addMethodsWhenNoConflictingTypes(JavaAttributeInfo javaAttributeInfo, YangPluginConfig pluginConfig, List<YangType<?>> types) throws IOException {
        if ((this.getGeneratedTempFiles() & 0x200) != 0) {
            this.addOfStringMethod(javaAttributeInfo, pluginConfig);
        }
        if ((this.getGeneratedTempFiles() & 0x400) != 0) {
            this.addTypeConstructor(javaAttributeInfo, types.indexOf(javaAttributeInfo.getAttributeType()));
        }
    }

    private void addMethodsInConflictCase(YangPluginConfig pluginConfig) throws IOException {
        JavaAttributeInfo attr = this.getIntAttribute();
        if (attr != null) {
            attr = this.getUIntAttribute();
        }
        if (attr != null && attr.isIntConflict()) {
            if (this.getIntIndex() < this.getUIntIndex()) {
                this.getIntAttribute().setCurHolderOrCount(this.getUIntAttribute().getCurHolderOrCount());
                this.appendToFile(this.getOfStringImplTempFileHandle(), MethodsGenerator.getOfMethodStringAndJavaDoc(this.getIntAttribute(), this.getGeneratedJavaClassName()) + "\n");
                this.addGetterImpl(this.getIntAttribute());
                this.addFromStringMethod(this.getIntAttribute(), pluginConfig);
            } else {
                this.getUIntAttribute().setCurHolderOrCount(this.getIntAttribute().getCurHolderOrCount());
                this.appendToFile(this.getOfStringImplTempFileHandle(), MethodsGenerator.getOfMethodStringAndJavaDoc(this.getUIntAttribute(), this.getGeneratedJavaClassName()) + "\n");
                this.addGetterImpl(this.getUIntAttribute());
                this.addFromStringMethod(this.getUIntAttribute(), pluginConfig);
            }
        }
        if ((attr = this.getLongAttribute()) != null) {
            attr = this.getULongAttribute();
        }
        if (attr != null && attr.isLongConflict()) {
            if (this.getLongIndex() < this.getULongIndex()) {
                this.getLongAttribute().setCurHolderOrCount(this.getULongAttribute().getCurHolderOrCount());
                this.appendToFile(this.getOfStringImplTempFileHandle(), MethodsGenerator.getOfMethodStringAndJavaDoc(this.getLongAttribute(), this.getGeneratedJavaClassName()) + "\n");
                this.addGetterImpl(this.getLongAttribute());
                this.addFromStringMethod(this.getLongAttribute(), pluginConfig);
            } else {
                this.getULongAttribute().setCurHolderOrCount(this.getLongAttribute().getCurHolderOrCount());
                this.appendToFile(this.getOfStringImplTempFileHandle(), MethodsGenerator.getOfMethodStringAndJavaDoc(this.getULongAttribute(), this.getGeneratedJavaClassName()) + "\n");
                this.addGetterImpl(this.getULongAttribute());
                this.addFromStringMethod(this.getULongAttribute(), pluginConfig);
            }
        }
        if ((attr = this.getShortAttribute()) != null) {
            attr = this.getUInt8Attribute();
        }
        if (attr != null && attr.isShortConflict()) {
            if (this.getShortIndex() < this.getUInt8Index()) {
                this.getShortAttribute().setCurHolderOrCount(this.getUInt8Attribute().getCurHolderOrCount());
                this.appendToFile(this.getOfStringImplTempFileHandle(), MethodsGenerator.getOfMethodStringAndJavaDoc(this.getShortAttribute(), this.getGeneratedJavaClassName()) + "\n");
                this.addGetterImpl(this.getShortAttribute());
                this.addFromStringMethod(this.getShortAttribute(), pluginConfig);
            } else {
                this.getUInt8Attribute().setCurHolderOrCount(this.getShortAttribute().getCurHolderOrCount());
                this.appendToFile(this.getOfStringImplTempFileHandle(), MethodsGenerator.getOfMethodStringAndJavaDoc(this.getUInt8Attribute(), this.getGeneratedJavaClassName()) + "\n");
                this.addGetterImpl(this.getUInt8Attribute());
                this.addFromStringMethod(this.getUInt8Attribute(), pluginConfig);
            }
        }
    }

    private void addFromStringMethod(JavaAttributeInfo newAttrInfo, YangPluginConfig pluginConfig) throws IOException {
        JavaQualifiedTypeInfoTranslator qualifiedInfoOfFromString = JavaQualifiedTypeInfoTranslator.getQualifiedInfoOfFromString(newAttrInfo, pluginConfig.getConflictResolver());
        JavaAttributeInfo fromStringAttributeInfo = JavaAttributeInfo.getAttributeInfoForTheData(qualifiedInfoOfFromString, newAttrInfo.getAttributeName(), newAttrInfo.getAttributeType(), this.getIsQualifiedAccessOrAddToImportList(qualifiedInfoOfFromString), false);
        this.addFromStringMethod(newAttrInfo, fromStringAttributeInfo);
    }

    private void addTypeConstructor(JavaAttributeInfo attr, int count) throws IOException {
        this.appendToFile(this.getConstructorForTypeTempFileHandle(), MethodsGenerator.getTypeConstructorStringAndJavaDoc(attr, this.getGeneratedJavaClassName(), this.getGeneratedJavaFiles(), count) + "\n");
    }

    private void addTypeConstructor() throws IOException {
        JavaAttributeInfo attr = this.getIntAttribute();
        if (attr != null) {
            attr = this.getUIntAttribute();
        }
        boolean index = this.getIntIndex() < this.getUIntIndex();
        int count = index ? this.getIntIndex() : this.getUIntIndex();
        if (attr != null && attr.isIntConflict()) {
            this.appendToFile(this.getConstructorForTypeTempFileHandle(), MethodsGenerator.getTypeConstructorStringAndJavaDoc(this.getIntAttribute(), this.getUIntAttribute(), this.getGeneratedJavaClassName(), ValidatorTypeForUnionTypes.INT_TYPE_CONFLICT, index, count) + "\n");
        }
        if ((attr = this.getLongAttribute()) != null) {
            attr = this.getULongAttribute();
        }
        index = this.getLongIndex() < this.getULongIndex();
        count = index ? this.getLongIndex() : this.getULongIndex();
        if (attr != null && attr.isLongConflict()) {
            this.appendToFile(this.getConstructorForTypeTempFileHandle(), MethodsGenerator.getTypeConstructorStringAndJavaDoc(this.getLongAttribute(), this.getULongAttribute(), this.getGeneratedJavaClassName(), ValidatorTypeForUnionTypes.LONG_TYPE_CONFLICT, index, count) + "\n");
        }
        if ((attr = this.getShortAttribute()) != null) {
            attr = this.getUInt8Attribute();
        }
        index = this.getShortIndex() < this.getUInt8Index();
        count = index ? this.getShortIndex() : this.getUInt8Index();
        if (attr != null && attr.isShortConflict()) {
            this.appendToFile(this.getConstructorForTypeTempFileHandle(), MethodsGenerator.getTypeConstructorStringAndJavaDoc(this.getShortAttribute(), this.getUInt8Attribute(), this.getGeneratedJavaClassName(), ValidatorTypeForUnionTypes.SHORT_TYPE_CONFLICT, index, count) + "\n");
        }
    }

    private void addOfStringMethod(JavaAttributeInfo attr, YangPluginConfig pluginConfig) throws IOException {
        this.appendToFile(this.getOfStringImplTempFileHandle(), MethodsGenerator.getOfMethodStringAndJavaDoc(attr, this.getGeneratedJavaClassName()) + "\n");
    }

    @Override
    public void freeTemporaryResources(boolean isErrorOccurred) throws IOException {
        if ((this.getGeneratedJavaFiles() & 0x40) != 0 || (this.getGeneratedJavaFiles() & 0x80) != 0) {
            FileSystemUtil.closeFile(this.typeClassJavaFileHandle, isErrorOccurred);
        }
        if ((this.getGeneratedTempFiles() & 0x400) != 0) {
            FileSystemUtil.closeFile(this.constructorForTypeTempFileHandle, true);
        }
        if ((this.getGeneratedTempFiles() & 0x200) != 0) {
            FileSystemUtil.closeFile(this.ofStringImplTempFileHandle, true);
        }
        if ((this.getGeneratedTempFiles() & 0x800) != 0) {
            FileSystemUtil.closeFile(this.getFromStringImplTempFileHandle(), true);
        }
        super.freeTemporaryResources(isErrorOccurred);
    }

    @Override
    public void generateJavaFile(int fileType, YangNode curNode) throws IOException {
        String bit;
        List<Object> imports = new ArrayList<String>();
        if (this.isAttributePresent()) {
            imports = this.getJavaImportData().getImports(true);
        }
        JavaIdentifierSyntax.createPackage(curNode);
        imports.add(this.getJavaImportData().getImportForHashAndEquals());
        if ((fileType & 0x40) != 0) {
            this.setTypedefClassJavaFileHandle(this.getJavaFileHandle(this.getJavaClassName("")));
            JavaFileGenerator.generateTypeDefClassFile(this.getTypedefClassJavaFileHandle(), curNode, imports);
        }
        if (!imports.contains(bit = this.getJavaImportData().getImportForToBitSet())) {
            imports.add(bit);
        }
        if ((fileType & 0x80) != 0) {
            this.setTypeClassJavaFileHandle(this.getJavaFileHandle(this.getJavaClassName("")));
            JavaFileGenerator.generateUnionClassFile(this.getTypeClassJavaFileHandle(), curNode, imports);
        }
        this.freeTemporaryResources(false);
    }

    public int getShortIndex() {
        return this.shortIndex;
    }

    private void setShortIndex(int shortIndex) {
        this.shortIndex = shortIndex;
    }

    public int getUInt8Index() {
        return this.uInt8Index;
    }

    private void setUInt8Index(int uInt8Index) {
        this.uInt8Index = uInt8Index;
    }

    public int getIntIndex() {
        return this.intIndex;
    }

    private void setIntIndex(int intIndex) {
        this.intIndex = intIndex;
    }

    public int getUIntIndex() {
        return this.uIntIndex;
    }

    private void setUIntIndex(int uIntIndex) {
        this.uIntIndex = uIntIndex;
    }

    public int getLongIndex() {
        return this.longIndex;
    }

    private void setLongIndex(int longIndex) {
        this.longIndex = longIndex;
    }

    public int getULongIndex() {
        return this.uLongIndex;
    }

    private void setULongIndex(int uLongIndex) {
        this.uLongIndex = uLongIndex;
    }

    private boolean validateForConflictingIntTypes(List<YangType<?>> typeList) {
        boolean isIntPresent = false;
        boolean isUIntPresent = false;
        for (YangType<?> type : typeList) {
            if (type.getDataType().equals((Object)YangDataTypes.INT32)) {
                this.setIntIndex(typeList.indexOf(type));
                isIntPresent = true;
            }
            if (!type.getDataType().equals((Object)YangDataTypes.UINT16)) continue;
            this.setUIntIndex(typeList.indexOf(type));
            isUIntPresent = true;
        }
        return isIntPresent && isUIntPresent;
    }

    private boolean validateForConflictingShortTypes(List<YangType<?>> typeList) {
        boolean isShortPresent = false;
        boolean isUInt8Present = false;
        for (YangType<?> type : typeList) {
            if (type.getDataType().equals((Object)YangDataTypes.INT16)) {
                this.setShortIndex(typeList.indexOf(type));
                isShortPresent = true;
            }
            if (!type.getDataType().equals((Object)YangDataTypes.UINT8)) continue;
            this.setUInt8Index(typeList.indexOf(type));
            isUInt8Present = true;
        }
        return isShortPresent && isUInt8Present;
    }

    private boolean validateForConflictingLongTypes(List<YangType<?>> typeList) {
        boolean isLongPresent = false;
        boolean isULongPresent = false;
        for (YangType<?> type : typeList) {
            if (type.getDataType().equals((Object)YangDataTypes.INT64)) {
                this.setLongIndex(typeList.indexOf(type));
                isLongPresent = true;
            }
            if (!type.getDataType().equals((Object)YangDataTypes.UINT32)) continue;
            this.setULongIndex(typeList.indexOf(type));
            isULongPresent = true;
        }
        return isLongPresent && isULongPresent;
    }

    private void updateAttributeCondition(JavaAttributeInfo javaAttributeInfo) {
        if (javaAttributeInfo.isIntConflict()) {
            if (javaAttributeInfo.getAttributeType().getDataType() == YangDataTypes.UINT16) {
                this.setUIntAttribute(javaAttributeInfo);
            } else if (javaAttributeInfo.getAttributeType().getDataType() == YangDataTypes.INT32) {
                this.setIntAttribute(javaAttributeInfo);
            }
        }
        if (javaAttributeInfo.isLongConflict()) {
            if (javaAttributeInfo.getAttributeType().getDataType() == YangDataTypes.UINT32) {
                this.setULongAttribute(javaAttributeInfo);
            } else if (javaAttributeInfo.getAttributeType().getDataType() == YangDataTypes.INT64) {
                this.setLongAttribute(javaAttributeInfo);
            }
        }
        if (javaAttributeInfo.isShortConflict()) {
            if (javaAttributeInfo.getAttributeType().getDataType() == YangDataTypes.UINT8) {
                this.setUInt8Attribute(javaAttributeInfo);
            } else if (javaAttributeInfo.getAttributeType().getDataType() == YangDataTypes.INT16) {
                this.setShortAttribute(javaAttributeInfo);
            }
        }
    }

    public JavaAttributeInfo getIntAttribute() {
        return this.intAttribute;
    }

    private void setIntAttribute(JavaAttributeInfo intAttribute) {
        this.intAttribute = intAttribute;
    }

    public JavaAttributeInfo getLongAttribute() {
        return this.longAttribute;
    }

    private void setLongAttribute(JavaAttributeInfo longAttribute) {
        this.longAttribute = longAttribute;
    }

    public JavaAttributeInfo getUIntAttribute() {
        return this.uIntAttribute;
    }

    private void setUIntAttribute(JavaAttributeInfo uIntAttribute) {
        this.uIntAttribute = uIntAttribute;
    }

    public JavaAttributeInfo getULongAttribute() {
        return this.uLongAttribute;
    }

    private void setULongAttribute(JavaAttributeInfo uLongAttribute) {
        this.uLongAttribute = uLongAttribute;
    }

    public JavaAttributeInfo getUInt8Attribute() {
        return this.uInt8Attribute;
    }

    private void setUInt8Attribute(JavaAttributeInfo uInt8Attribute) {
        this.uInt8Attribute = uInt8Attribute;
    }

    public JavaAttributeInfo getShortAttribute() {
        return this.shortAttribute;
    }

    private void setShortAttribute(JavaAttributeInfo shortAttribute) {
        this.shortAttribute = shortAttribute;
    }
}

