/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.linker.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.onosproject.yangutils.datamodel.ResolvableType;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangReferenceResolver;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.linker.YangLinker;
import org.onosproject.yangutils.linker.exceptions.LinkerException;
import org.onosproject.yangutils.linker.impl.YangLinkerUtils;

public class YangLinkerManager
implements YangLinker {
    private Set<YangNode> yangNodeSet = new HashSet<YangNode>();

    public Set<YangNode> getYangNodeSet() {
        return this.yangNodeSet;
    }

    public void createYangNodeSet(Set<YangNode> yangNodeSet) {
        this.getYangNodeSet().addAll(yangNodeSet);
    }

    @Override
    public void resolveDependencies(Set<YangNode> yangNodeSet) {
        this.createYangNodeSet(yangNodeSet);
        this.linkSubModulesToParentModule(yangNodeSet);
        this.addRefToYangFilesImportList(yangNodeSet);
        this.addRefToYangFilesIncludeList(yangNodeSet);
        YangLinkerUtils.updateFilePriority(yangNodeSet);
        this.processInterFileLinking(yangNodeSet);
    }

    public void linkSubModulesToParentModule(Set<YangNode> yangNodeSet) throws LinkerException {
        for (YangNode yangNode : yangNodeSet) {
            if (!(yangNode instanceof YangSubModule)) continue;
            try {
                ((YangSubModule)yangNode).linkWithModule(this.getYangNodeSet());
            }
            catch (DataModelException e) {
                String errorInfo = "Error in file: " + yangNode.getName() + " in " + yangNode.getFileName() + " at " + "line: " + e.getLineNumber() + " at position: " + e.getCharPositionInLine() + "\n" + e.getLocalizedMessage();
                throw new LinkerException(errorInfo);
            }
        }
    }

    public void addRefToYangFilesImportList(Set<YangNode> yangNodeSet) throws LinkerException {
        for (YangNode yangNode : yangNodeSet) {
            if (!(yangNode instanceof YangReferenceResolver)) continue;
            try {
                ((YangReferenceResolver)yangNode).addReferencesToImportList(this.getYangNodeSet());
            }
            catch (DataModelException e) {
                String errorInfo = "Error in file: " + yangNode.getName() + " in " + yangNode.getFileName() + " at " + "line: " + e.getLineNumber() + " at position: " + e.getCharPositionInLine() + "\n" + e.getLocalizedMessage();
                throw new LinkerException(errorInfo);
            }
        }
    }

    public void addRefToYangFilesIncludeList(Set<YangNode> yangNodeSet) throws LinkerException {
        for (YangNode yangNode : yangNodeSet) {
            if (!(yangNode instanceof YangReferenceResolver)) continue;
            try {
                ((YangReferenceResolver)yangNode).addReferencesToIncludeList(this.getYangNodeSet());
            }
            catch (DataModelException e) {
                String errorInfo = "Error in file: " + yangNode.getName() + " in " + yangNode.getFileName() + " at " + "line: " + e.getLineNumber() + " at position: " + e.getCharPositionInLine() + "\n" + e.getLocalizedMessage();
                throw new LinkerException(errorInfo);
            }
        }
    }

    public void processInterFileLinking(Set<YangNode> yangNodeSet) throws LinkerException {
        LinkedList<YangNode> yangNodeSortedList = new LinkedList<YangNode>();
        yangNodeSortedList.addAll(yangNodeSet);
        Collections.sort(yangNodeSortedList);
        for (YangNode yangNode : yangNodeSortedList) {
            try {
                ((YangReferenceResolver)yangNode).resolveInterFileLinking(ResolvableType.YANG_IF_FEATURE);
                ((YangReferenceResolver)yangNode).resolveInterFileLinking(ResolvableType.YANG_USES);
                ((YangReferenceResolver)yangNode).resolveInterFileLinking(ResolvableType.YANG_AUGMENT);
                ((YangReferenceResolver)yangNode).resolveInterFileLinking(ResolvableType.YANG_DERIVED_DATA_TYPE);
                ((YangReferenceResolver)yangNode).resolveInterFileLinking(ResolvableType.YANG_BASE);
                ((YangReferenceResolver)yangNode).resolveInterFileLinking(ResolvableType.YANG_IDENTITYREF);
                ((YangReferenceResolver)yangNode).resolveInterFileLinking(ResolvableType.YANG_LEAFREF);
                ((YangReferenceResolver)yangNode).resolveInterFileLinking(ResolvableType.YANG_COMPILER_ANNOTATION);
            }
            catch (DataModelException e) {
                String errorInfo = "Error in file: " + yangNode.getName() + " in " + yangNode.getFileName() + " at " + "line: " + e.getLineNumber() + " at position: " + e.getCharPositionInLine() + "\n" + e.getLocalizedMessage();
                throw new LinkerException(errorInfo);
            }
            catch (LinkerException e) {
                String errorInfo = "Error in file: " + yangNode.getName() + " in " + yangNode.getFileName() + " at " + "line: " + e.getLineNumber() + " at position: " + e.getCharPositionInLine() + "\n" + e.getLocalizedMessage();
                throw new LinkerException(errorInfo);
            }
        }
    }
}

