/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyDictionary<S, T>
extends Dictionary<S, T>
implements Map<S, T> {
    private final Hashtable<S, T> m_delegate;

    public ReadOnlyDictionary(Dictionary<S, T> delegate) {
        if (delegate instanceof Hashtable) {
            this.m_delegate = (Hashtable)delegate;
        } else {
            this.m_delegate = new Hashtable();
            Enumeration<S> ke = delegate.keys();
            while (ke.hasMoreElements()) {
                S key = ke.nextElement();
                this.m_delegate.put(key, delegate.get(key));
            }
        }
    }

    public ReadOnlyDictionary(ServiceReference serviceReference) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] keys = serviceReference.getPropertyKeys();
        if (keys != null) {
            for (int j = 0; j < keys.length; ++j) {
                String key = keys[j];
                properties.put(key, serviceReference.getProperty(key));
            }
        }
        this.m_delegate = properties;
    }

    @Override
    public Enumeration<T> elements() {
        return this.m_delegate.elements();
    }

    @Override
    public T get(Object key) {
        return this.m_delegate.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.m_delegate.isEmpty();
    }

    @Override
    public Enumeration<S> keys() {
        return this.m_delegate.keys();
    }

    @Override
    public T put(S key, T value) {
        return null;
    }

    @Override
    public T remove(Object key) {
        return null;
    }

    @Override
    public int size() {
        return this.m_delegate.size();
    }

    public String toString() {
        return this.m_delegate.toString();
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.m_delegate.containsValue(value);
    }

    @Override
    public Set entrySet() {
        return Collections.unmodifiableSet(this.m_delegate.entrySet());
    }

    @Override
    public Set keySet() {
        return Collections.unmodifiableSet(this.m_delegate.keySet());
    }

    @Override
    public void putAll(Map m) {
    }

    @Override
    public Collection values() {
        return Collections.unmodifiableCollection(this.m_delegate.values());
    }
}

