/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.felix.scr.impl.ScrCommand;
import org.apache.felix.shell.Command;

class ScrShellCommand
implements Command {
    private static final String HELP_CMD = "help";
    private static final String LIST_CMD = "list";
    private static final String INFO_CMD = "info";
    private static final String ENABLE_CMD = "enable";
    private static final String DISABLE_CMD = "disable";
    private static final String CONFIG_CMD = "config";
    private final ScrCommand scrCommand;

    ScrShellCommand(ScrCommand scrCommand) {
        this.scrCommand = scrCommand;
    }

    public String getName() {
        return "scr";
    }

    public String getUsage() {
        return "scr help";
    }

    public String getShortDescription() {
        return "Declarative Services Runtime";
    }

    public void execute(String commandLine, PrintStream out, PrintStream err) {
        String arg;
        String[] st = commandLine.split("//s");
        String command = st.length > 1 ? st[1] : HELP_CMD;
        String string = arg = st.length > 2 ? st[2] : null;
        if (command.equals(HELP_CMD)) {
            this.help(out, arg);
        } else {
            PrintWriter pw = new PrintWriter(out);
            try {
                if (command.equals(LIST_CMD)) {
                    this.scrCommand.list(arg, pw);
                } else if (command.equals(INFO_CMD)) {
                    this.scrCommand.info(arg, pw);
                } else if (command.equals(ENABLE_CMD)) {
                    this.scrCommand.change(arg, pw, true);
                } else if (command.equals(DISABLE_CMD)) {
                    this.scrCommand.change(arg, pw, false);
                } else if (command.equals(CONFIG_CMD)) {
                    this.scrCommand.config(pw);
                } else {
                    err.println("Unknown command: " + command);
                }
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    private void help(PrintStream out, String command) {
        if (command.equals(LIST_CMD)) {
            out.println("");
            out.println("scr list [ <bundleId> ]");
            out.println("");
            out.println("This command lists registered components. If a bundle ID is\nadded, only the components of the selected bundles are listed.");
            out.println("");
        } else if (command.equals(INFO_CMD)) {
            out.println("");
            out.println("scr info <componentId>");
            out.println("");
            out.println("This command dumps information of the component whose\ncomponent ID is given as command argument.");
            out.println("");
        } else if (command.equals(ENABLE_CMD)) {
            out.println("");
            out.println("scr enable <componentId>");
            out.println("");
            out.println("This command enables the component whose component ID\nis given as command argument.");
            out.println("");
        } else if (command.equals(DISABLE_CMD)) {
            out.println("");
            out.println("scr disable <componentId>");
            out.println("");
            out.println("This command disables the component whose component ID\nis given as command argument.");
            out.println("");
        } else if (command.equals(CONFIG_CMD)) {
            out.println("");
            out.println("scr config");
            out.println("");
            out.println("This command lists the current SCR configuration.");
            out.println("");
        } else {
            out.println("scr help [list]");
            out.println("scr list [ <bundleId> ]");
            out.println("scr info <componentId>");
            out.println("scr enable <componentId>");
            out.println("scr disable <componentId>");
            out.println("scr config");
        }
    }
}

