/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.ByteBuffer;
import java.util.Dictionary;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IP;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=false)
public class DirectHostManager {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService componentConfigService;
    private static final boolean DEFAULT_ENABLED = false;
    @Property(name="enabled", boolValue={false}, label="Enable reactive directly-connected host processing")
    private volatile boolean enabled = false;
    private static final String APP_NAME = "org.onosproject.directhost";
    private static final long MAX_QUEUED_PACKETS = 10000L;
    private static final long MAX_QUEUE_DURATION = 2L;
    private ApplicationId appId;
    private InternalPacketProcessor packetProcessor = new InternalPacketProcessor();
    private InternalHostListener hostListener = new InternalHostListener();
    private Cache<IpAddress, Queue<IP>> ipPacketCache = CacheBuilder.newBuilder().weigher((key, value) -> value.size()).maximumWeight(10000L).expireAfterAccess(2L, TimeUnit.SECONDS).build();

    @Activate
    public void activate(ComponentContext context) {
        this.componentConfigService.registerProperties(this.getClass());
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.modified(context);
    }

    @Modified
    private void modified(ComponentContext context) {
        Boolean boolEnabled = Tools.isPropertyEnabled((Dictionary)context.getProperties(), (String)"enabled");
        if (boolEnabled != null) {
            if (this.enabled && !boolEnabled.booleanValue()) {
                this.enabled = false;
                this.disable();
            } else if (!this.enabled && boolEnabled.booleanValue()) {
                this.enabled = true;
                this.enable();
            }
        }
    }

    private void enable() {
        this.hostService.addListener((EventListener)this.hostListener);
        this.packetService.addProcessor((PacketProcessor)this.packetProcessor, PacketProcessor.director((int)3));
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(EthType.EtherType.IPV4.ethType().toShort()).build();
        this.packetService.requestPackets(selector, PacketPriority.REACTIVE, this.appId, Optional.empty());
        selector = DefaultTrafficSelector.builder().matchEthType(EthType.EtherType.IPV6.ethType().toShort()).build();
        this.packetService.requestPackets(selector, PacketPriority.REACTIVE, this.appId, Optional.empty());
    }

    private void disable() {
        this.packetService.removeProcessor((PacketProcessor)this.packetProcessor);
        this.hostService.removeListener((EventListener)this.hostListener);
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(EthType.EtherType.IPV4.ethType().toShort()).build();
        this.packetService.cancelPackets(selector, PacketPriority.REACTIVE, this.appId, Optional.empty());
        selector = DefaultTrafficSelector.builder().matchEthType(EthType.EtherType.IPV6.ethType().toShort()).build();
        this.packetService.cancelPackets(selector, PacketPriority.REACTIVE, this.appId, Optional.empty());
    }

    @Deactivate
    public void deactivate() {
        if (this.enabled) {
            this.disable();
        }
        this.componentConfigService.unregisterProperties(this.getClass(), false);
    }

    private boolean handle(Ethernet eth) {
        IpAddress dstIp;
        IPv4 ip2;
        Preconditions.checkNotNull((Object)eth);
        if (!this.enabled || eth.getEtherType() != Ethernet.TYPE_IPV6 && eth.getEtherType() != Ethernet.TYPE_IPV4) {
            return false;
        }
        if (eth.getEtherType() == Ethernet.TYPE_IPV4) {
            ip2 = (IPv4)eth.getPayload();
            dstIp = IpAddress.valueOf((int)ip2.getDestinationAddress());
        } else {
            ip2 = (IPv6)eth.getPayload();
            dstIp = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])ip2.getDestinationAddress());
        }
        Interface egressInterface = this.interfaceService.getMatchingInterface(dstIp);
        if (egressInterface == null) {
            this.log.info("No egress interface found for {}", (Object)dstIp);
            return false;
        }
        Optional<Host> host = this.hostService.getHostsByIp(dstIp).stream().filter(h -> h.location().equals((Object)egressInterface.connectPoint())).filter(h -> h.vlan().equals((Object)egressInterface.vlan())).findAny();
        if (host.isPresent()) {
            this.transformAndSend((IP)eth.getPayload(), eth.getEtherType(), egressInterface, host.get().mac());
        } else {
            this.hostService.startMonitoringIp(dstIp);
            this.ipPacketCache.asMap().compute(dstIp, (ip, queue) -> {
                if (queue == null) {
                    queue = new ConcurrentLinkedQueue<IP>();
                }
                queue.add((IP)eth.getPayload());
                return queue;
            });
        }
        return true;
    }

    private void transformAndSend(IP ip, short ethType, Interface egressInterface, MacAddress macAddress) {
        if (ethType == Ethernet.TYPE_IPV4) {
            IPv4 ipv4 = (IPv4)ip;
            ipv4.setTtl((byte)(ipv4.getTtl() - 1));
            ipv4.setChecksum((short)0);
        } else {
            IPv6 ipv6 = (IPv6)ip;
            ipv6.setHopLimit((byte)(ipv6.getHopLimit() - 1));
            ipv6.resetChecksum();
        }
        Ethernet eth = new Ethernet();
        eth.setDestinationMACAddress(macAddress);
        eth.setSourceMACAddress(egressInterface.mac());
        eth.setEtherType(ethType);
        eth.setPayload((IPacket)ip);
        if (!egressInterface.vlan().equals((Object)VlanId.NONE)) {
            eth.setVlanID(egressInterface.vlan().toShort());
        }
        this.send(eth, egressInterface.connectPoint());
    }

    private void send(Ethernet eth, ConnectPoint cp) {
        DefaultOutboundPacket packet = new DefaultOutboundPacket(cp.deviceId(), DefaultTrafficTreatment.builder().setOutput(cp.port()).build(), ByteBuffer.wrap(eth.serialize()));
        this.packetService.emit((OutboundPacket)packet);
    }

    private void sendQueued(IpAddress ipAddress, MacAddress macAddress) {
        this.log.debug("Sending queued packets for {} ({})", (Object)ipAddress, (Object)macAddress);
        this.ipPacketCache.asMap().computeIfPresent(ipAddress, (ip, packets) -> {
            packets.forEach(ipPackets -> {
                Interface egressInterface = this.interfaceService.getMatchingInterface(ipAddress);
                if (egressInterface == null) {
                    this.log.info("No egress interface found for {}", (Object)ipAddress);
                    return;
                }
                this.transformAndSend((IP)ipPackets, ipAddress.isIp4() ? Ethernet.TYPE_IPV4 : Ethernet.TYPE_IPV6, egressInterface, macAddress);
            });
            return null;
        });
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindComponentConfigService(ComponentConfigService componentConfigService) {
        this.componentConfigService = componentConfigService;
    }

    protected void unbindComponentConfigService(ComponentConfigService componentConfigService) {
        if (this.componentConfigService == componentConfigService) {
            this.componentConfigService = null;
        }
    }

    private class InternalHostListener
    implements HostListener {
        private InternalHostListener() {
        }

        public void event(HostEvent event) {
            switch ((HostEvent.Type)event.type()) {
                case HOST_ADDED: {
                    ((Host)event.subject()).ipAddresses().forEach(ip -> DirectHostManager.this.sendQueued(ip, ((Host)event.subject()).mac()));
                    break;
                }
            }
        }
    }

    private class InternalPacketProcessor
    implements PacketProcessor {
        private InternalPacketProcessor() {
        }

        public void process(PacketContext context) {
            if (context.isHandled()) {
                return;
            }
            if (DirectHostManager.this.interfaceService.getInterfacesByPort(context.inPacket().receivedFrom()).isEmpty()) {
                return;
            }
            Ethernet eth = context.inPacket().parsed();
            if (eth == null) {
                return;
            }
            if (!DirectHostManager.this.handle(eth)) {
                return;
            }
            context.block();
        }
    }
}

