/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.config.impl;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.routing.config.BgpConfig;
import org.onosproject.routing.config.RouterConfig;
import org.onosproject.routing.config.RoutersConfig;
import org.onosproject.routing.config.RoutingConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class RoutingConfigurationImpl
implements RoutingConfigurationService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry registry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    private ConfigFactory<ApplicationId, BgpConfig> bgpConfigFactory = new ConfigFactory<ApplicationId, BgpConfig>(SubjectFactories.APP_SUBJECT_FACTORY, BgpConfig.class, "bgp"){

        public BgpConfig createConfig() {
            return new BgpConfig();
        }
    };
    private ConfigFactory<ApplicationId, RouterConfig> routerConfigFactory = new ConfigFactory<ApplicationId, RouterConfig>(SubjectFactories.APP_SUBJECT_FACTORY, RouterConfig.class, "router"){

        public RouterConfig createConfig() {
            return new RouterConfig();
        }
    };
    private ConfigFactory<ApplicationId, RoutersConfig> routersConfigFactory = new ConfigFactory<ApplicationId, RoutersConfig>(SubjectFactories.APP_SUBJECT_FACTORY, RoutersConfig.class, "routers", true){

        public RoutersConfig createConfig() {
            return new RoutersConfig();
        }
    };

    @Activate
    public void activate() {
        this.registry.registerConfigFactory(this.bgpConfigFactory);
        this.registry.registerConfigFactory(this.routerConfigFactory);
        this.registry.registerConfigFactory(this.routersConfigFactory);
        this.log.info("Routing configuration service started");
    }

    @Deactivate
    public void deactivate() {
        this.registry.unregisterConfigFactory(this.bgpConfigFactory);
        this.registry.unregisterConfigFactory(this.routerConfigFactory);
        this.registry.unregisterConfigFactory(this.routersConfigFactory);
        this.log.info("Routing configuration service stopped");
    }

    protected void bindRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.registry = networkConfigRegistry;
    }

    protected void unbindRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.registry == networkConfigRegistry) {
            this.registry = null;
        }
    }

    protected void bindConfigService(NetworkConfigService networkConfigService) {
        this.configService = networkConfigService;
    }

    protected void unbindConfigService(NetworkConfigService networkConfigService) {
        if (this.configService == networkConfigService) {
            this.configService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }
}

