/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.routing.bgp.BgpConstants;
import org.onosproject.routing.bgp.BgpInfoService;
import org.onosproject.routing.bgp.BgpRouteEntry;
import org.onosproject.routing.bgp.BgpSession;

@Command(scope="onos", name="bgp-routes", description="Lists all BGP best routes")
public class BgpRoutesListCommand
extends AbstractShellCommand {
    @Option(name="-s", aliases={"--summary"}, description="BGP routes summary", required=false, multiValued=false)
    private boolean routesSummary = false;
    @Option(name="-n", aliases={"--neighbor"}, description="Routes from a BGP neighbor", required=false, multiValued=false)
    private String bgpNeighbor;
    private static final String FORMAT_SUMMARY_V4 = "Total BGP IPv4 routes = %d";
    private static final String FORMAT_SUMMARY_V6 = "Total BGP IPv6 routes = %d";
    private static final String FORMAT_HEADER = "   Network            Next Hop        Origin LocalPref       MED BGP-ID";
    private static final String FORMAT_ROUTE_LINE1 = "   %-18s %-15s %6s %9s %9s %-15s";
    private static final String FORMAT_ROUTE_LINE2 = "                      AsPath %s";

    protected void execute() {
        BgpInfoService service = (BgpInfoService)AbstractShellCommand.get(BgpInfoService.class);
        if (this.routesSummary) {
            this.printSummary(service.getBgpRoutes4(), service.getBgpRoutes6());
            return;
        }
        BgpSession foundBgpSession = null;
        if (this.bgpNeighbor != null) {
            for (BgpSession bgpSession : service.getBgpSessions()) {
                if (!bgpSession.remoteInfo().bgpId().toString().equals(this.bgpNeighbor)) continue;
                foundBgpSession = bgpSession;
                break;
            }
            if (foundBgpSession == null) {
                this.print("BGP neighbor %s not found", new Object[]{this.bgpNeighbor});
                return;
            }
        }
        if (foundBgpSession != null) {
            this.printRoutes(foundBgpSession.getBgpRibIn4(), foundBgpSession.getBgpRibIn6());
        } else {
            this.printRoutes(service.getBgpRoutes4(), service.getBgpRoutes6());
        }
    }

    private void printSummary(Collection<BgpRouteEntry> routes4, Collection<BgpRouteEntry> routes6) {
        if (this.outputJson()) {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode result = mapper.createObjectNode();
            result.put("totalRoutes4", routes4.size());
            result.put("totalRoutes6", routes6.size());
            this.print("%s", new Object[]{result});
        } else {
            this.print(FORMAT_SUMMARY_V4, new Object[]{routes4.size()});
            this.print(FORMAT_SUMMARY_V6, new Object[]{routes6.size()});
        }
    }

    private void printRoutes(Collection<BgpRouteEntry> routes4, Collection<BgpRouteEntry> routes6) {
        if (this.outputJson()) {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode result = mapper.createObjectNode();
            result.set("routes4", this.json(routes4));
            result.set("routes6", this.json(routes6));
            this.print("%s", new Object[]{result});
        } else {
            this.print(FORMAT_HEADER, new Object[0]);
            for (BgpRouteEntry route : routes4) {
                this.printRoute(route);
            }
            this.print(FORMAT_SUMMARY_V4, new Object[]{routes4.size()});
            this.print("", new Object[0]);
            this.print(FORMAT_HEADER, new Object[0]);
            for (BgpRouteEntry route : routes6) {
                this.printRoute(route);
            }
            this.print(FORMAT_SUMMARY_V6, new Object[]{routes6.size()});
        }
    }

    private void printRoute(BgpRouteEntry route) {
        if (route != null) {
            this.print(FORMAT_ROUTE_LINE1, new Object[]{route.prefix(), route.nextHop(), BgpConstants.Update.Origin.typeToString(route.getOrigin()), route.getLocalPref(), route.getMultiExitDisc(), route.getBgpSession().remoteInfo().bgpId()});
            this.print(FORMAT_ROUTE_LINE2, new Object[]{this.asPath4Cli(route.getAsPath())});
        }
    }

    private String asPath4Cli(BgpRouteEntry.AsPath asPath) {
        ArrayList<BgpRouteEntry.PathSegment> pathSegments = asPath.getPathSegments();
        if (pathSegments.isEmpty()) {
            return "[none]";
        }
        StringBuilder builder = new StringBuilder();
        for (BgpRouteEntry.PathSegment pathSegment : pathSegments) {
            String prefix = null;
            String suffix = null;
            switch (pathSegment.getType()) {
                case 1: {
                    prefix = "[AS-Set";
                    suffix = "]";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    prefix = "[AS-Confed-Seq";
                    suffix = "]";
                    break;
                }
                case 4: {
                    prefix = "[AS-Confed-Set";
                    suffix = "]";
                    break;
                }
                default: {
                    builder.append(String.format("(type = %s)", BgpConstants.Update.AsPath.typeToString(pathSegment.getType())));
                }
            }
            if (prefix != null) {
                if (builder.length() > 0) {
                    builder.append(" ");
                }
                builder.append(prefix);
            }
            for (Long asn : pathSegment.getSegmentAsNumbers()) {
                if (builder.length() > 0) {
                    builder.append(" ");
                }
                builder.append(String.format("%d", asn));
            }
            if (suffix == null) continue;
            builder.append(prefix);
        }
        return builder.toString();
    }

    private JsonNode json(Collection<BgpRouteEntry> routes) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (BgpRouteEntry route : routes) {
            result.add((JsonNode)this.json(mapper, route));
        }
        return result;
    }

    private ObjectNode json(ObjectMapper mapper, BgpRouteEntry route) {
        ObjectNode result = mapper.createObjectNode();
        result.put("prefix", route.prefix().toString());
        result.put("nextHop", route.nextHop().toString());
        result.put("bgpId", route.getBgpSession().remoteInfo().bgpId().toString());
        result.put("origin", BgpConstants.Update.Origin.typeToString(route.getOrigin()));
        result.set("asPath", (JsonNode)this.json(mapper, route.getAsPath()));
        result.put("localPref", route.getLocalPref());
        result.put("multiExitDisc", route.getMultiExitDisc());
        return result;
    }

    private ObjectNode json(ObjectMapper mapper, BgpRouteEntry.AsPath asPath) {
        ObjectNode result = mapper.createObjectNode();
        ArrayNode pathSegmentsJson = mapper.createArrayNode();
        for (BgpRouteEntry.PathSegment pathSegment : asPath.getPathSegments()) {
            ObjectNode pathSegmentJson = mapper.createObjectNode();
            pathSegmentJson.put("type", BgpConstants.Update.AsPath.typeToString(pathSegment.getType()));
            ArrayNode segmentAsNumbersJson = mapper.createArrayNode();
            for (Long asNumber : pathSegment.getSegmentAsNumbers()) {
                segmentAsNumbersJson.add(asNumber);
            }
            pathSegmentJson.set("segmentAsNumbers", (JsonNode)segmentAsNumbersJson);
            pathSegmentsJson.add((JsonNode)pathSegmentJson);
        }
        result.set("pathSegments", (JsonNode)pathSegmentsJson);
        return result;
    }
}

