/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.routing.bgp.BgpInfoService;
import org.onosproject.routing.bgp.BgpSession;

@Command(scope="onos", name="bgp-neighbors", description="Lists the BGP neighbors")
public class BgpNeighborsListCommand
extends AbstractShellCommand {
    @Option(name="-n", aliases={"--neighbor"}, description="BGP neighbor to display information about", required=false, multiValued=false)
    private String bgpNeighbor;
    private static final String FORMAT_NEIGHBOR_LINE1 = "BGP neighbor is %s, remote AS %d, local AS %d";
    private static final String FORMAT_NEIGHBOR_LINE2 = "  Remote router ID %s, IP %s, BGP version %d, Hold time %d";
    private static final String FORMAT_NEIGHBOR_LINE3 = "  Remote AFI/SAFI IPv4 Unicast %s Multicast %s, IPv6 Unicast %s Multicast %s";
    private static final String FORMAT_NEIGHBOR_LINE4 = "  Local  router ID %s, IP %s, BGP version %d, Hold time %d";
    private static final String FORMAT_NEIGHBOR_LINE5 = "  Local  AFI/SAFI IPv4 Unicast %s Multicast %s, IPv6 Unicast %s Multicast %s";
    private static final String FORMAT_NEIGHBOR_LINE6 = "  4 Octet AS Capability: %s %s";

    protected void execute() {
        BgpInfoService service = (BgpInfoService)AbstractShellCommand.get(BgpInfoService.class);
        Collection<BgpSession> bgpSessions = service.getBgpSessions();
        if (this.bgpNeighbor != null) {
            BgpSession foundBgpSession = null;
            for (BgpSession bgpSession : bgpSessions) {
                if (!bgpSession.remoteInfo().bgpId().toString().equals(this.bgpNeighbor)) continue;
                foundBgpSession = bgpSession;
                break;
            }
            if (foundBgpSession != null) {
                this.printNeighbor(foundBgpSession);
            } else {
                this.print("BGP neighbor %s not found", new Object[]{this.bgpNeighbor});
            }
            return;
        }
        this.printNeighbors(bgpSessions);
    }

    private void printNeighbors(Collection<BgpSession> bgpSessions) {
        if (this.outputJson()) {
            this.print("%s", new Object[]{this.json(bgpSessions)});
        } else {
            for (BgpSession bgpSession : bgpSessions) {
                this.printNeighbor(bgpSession);
            }
        }
    }

    private void printNeighbor(BgpSession bgpSession) {
        this.print(FORMAT_NEIGHBOR_LINE1, new Object[]{bgpSession.remoteInfo().bgpId().toString(), bgpSession.remoteInfo().asNumber(), bgpSession.localInfo().asNumber()});
        this.print(FORMAT_NEIGHBOR_LINE2, new Object[]{bgpSession.remoteInfo().bgpId().toString(), bgpSession.remoteInfo().address().toString(), bgpSession.remoteInfo().bgpVersion(), bgpSession.remoteInfo().holdtime()});
        this.print(FORMAT_NEIGHBOR_LINE3, new Object[]{bgpSession.remoteInfo().ipv4Unicast() ? "YES" : "NO", bgpSession.remoteInfo().ipv4Multicast() ? "YES" : "NO", bgpSession.remoteInfo().ipv6Unicast() ? "YES" : "NO", bgpSession.remoteInfo().ipv6Multicast() ? "YES" : "NO"});
        this.print(FORMAT_NEIGHBOR_LINE4, new Object[]{bgpSession.localInfo().bgpId().toString(), bgpSession.localInfo().address().toString(), bgpSession.localInfo().bgpVersion(), bgpSession.localInfo().holdtime()});
        this.print(FORMAT_NEIGHBOR_LINE5, new Object[]{bgpSession.localInfo().ipv4Unicast() ? "YES" : "NO", bgpSession.localInfo().ipv4Multicast() ? "YES" : "NO", bgpSession.localInfo().ipv6Unicast() ? "YES" : "NO", bgpSession.localInfo().ipv6Multicast() ? "YES" : "NO"});
        if (bgpSession.localInfo().as4OctetCapability() || bgpSession.remoteInfo().as4OctetCapability()) {
            this.print(FORMAT_NEIGHBOR_LINE6, new Object[]{bgpSession.localInfo().as4OctetCapability() ? "Advertised" : "", bgpSession.remoteInfo().as4OctetCapability() ? "Received" : ""});
        }
    }

    private JsonNode json(Collection<BgpSession> bgpSessions) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (BgpSession bgpSession : bgpSessions) {
            result.add((JsonNode)this.json(mapper, bgpSession));
        }
        return result;
    }

    private ObjectNode json(ObjectMapper mapper, BgpSession bgpSession) {
        ObjectNode result = mapper.createObjectNode();
        result.put("remoteAddress", bgpSession.remoteInfo().address().toString());
        result.put("remoteBgpVersion", bgpSession.remoteInfo().bgpVersion());
        result.put("remoteAs", bgpSession.remoteInfo().asNumber());
        result.put("remoteAs4", bgpSession.remoteInfo().as4Number());
        result.put("remoteHoldtime", bgpSession.remoteInfo().holdtime());
        result.put("remoteBgpId", bgpSession.remoteInfo().bgpId().toString());
        result.put("remoteIpv4Unicast", bgpSession.remoteInfo().ipv4Unicast());
        result.put("remoteIpv4Multicast", bgpSession.remoteInfo().ipv4Multicast());
        result.put("remoteIpv6Unicast", bgpSession.remoteInfo().ipv6Unicast());
        result.put("remoteIpv6Multicast", bgpSession.remoteInfo().ipv6Multicast());
        result.put("localAddress", bgpSession.localInfo().address().toString());
        result.put("localBgpVersion", bgpSession.localInfo().bgpVersion());
        result.put("localAs", bgpSession.localInfo().asNumber());
        result.put("localAs4", bgpSession.localInfo().as4Number());
        result.put("localHoldtime", bgpSession.localInfo().holdtime());
        result.put("localBgpId", bgpSession.localInfo().bgpId().toString());
        result.put("localIpv4Unicast", bgpSession.localInfo().ipv4Unicast());
        result.put("localIpv4Multicast", bgpSession.localInfo().ipv4Multicast());
        result.put("localIpv6Unicast", bgpSession.localInfo().ipv6Unicast());
        result.put("localIpv6Multicast", bgpSession.localInfo().ipv6Multicast());
        return result;
    }
}

