/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.routing.bgp.RouteEntry;

public class RouteUpdate {
    private final Type type;
    private final RouteEntry routeEntry;

    public RouteUpdate(Type type, RouteEntry routeEntry) {
        this.type = type;
        this.routeEntry = (RouteEntry)Preconditions.checkNotNull((Object)routeEntry);
    }

    public Type type() {
        return this.type;
    }

    public RouteEntry routeEntry() {
        return this.routeEntry;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RouteUpdate)) {
            return false;
        }
        RouteUpdate otherUpdate = (RouteUpdate)other;
        return Objects.equals((Object)this.type, (Object)otherUpdate.type) && Objects.equals(this.routeEntry, otherUpdate.routeEntry);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.routeEntry});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("type", (Object)this.type).add("routeEntry", (Object)this.routeEntry).toString();
    }

    public static enum Type {
        UPDATE,
        DELETE;

    }
}

