/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;

public class RouteEntry {
    private final IpPrefix prefix;
    private final IpAddress nextHop;

    public RouteEntry(IpPrefix prefix, IpAddress nextHop) {
        this.prefix = (IpPrefix)Preconditions.checkNotNull((Object)prefix);
        this.nextHop = (IpAddress)Preconditions.checkNotNull((Object)nextHop);
    }

    public IpAddress.Version version() {
        return this.nextHop.version();
    }

    public boolean isIp4() {
        return this.nextHop.isIp4();
    }

    public boolean isIp6() {
        return this.nextHop.isIp6();
    }

    public IpPrefix prefix() {
        return this.prefix;
    }

    public IpAddress nextHop() {
        return this.nextHop;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RouteEntry otherRoute = (RouteEntry)other;
        return Objects.equals(this.prefix, otherRoute.prefix) && Objects.equals(this.nextHop, otherRoute.nextHop);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.nextHop);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("prefix", (Object)this.prefix).add("nextHop", (Object)this.nextHop).toString();
    }
}

