/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Dictionary;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.Ip6Prefix;
import org.onlab.packet.IpPrefix;
import org.onlab.util.Tools;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.incubator.net.routing.RouteAdminService;
import org.onosproject.routing.bgp.BgpFrameDecoder;
import org.onosproject.routing.bgp.BgpInfoService;
import org.onosproject.routing.bgp.BgpRouteEntry;
import org.onosproject.routing.bgp.BgpRouteSelector;
import org.onosproject.routing.bgp.BgpSession;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=false)
@Service
public class BgpSessionManager
implements BgpInfoService {
    private static final Logger log = LoggerFactory.getLogger(BgpSessionManager.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RouteAdminService routeService;
    boolean isShutdown = true;
    private Channel serverChannel;
    private ServerBootstrap serverBootstrap;
    private ChannelGroup allChannels = new DefaultChannelGroup();
    private ConcurrentMap<SocketAddress, BgpSession> bgpSessions = new ConcurrentHashMap<SocketAddress, BgpSession>();
    private Ip4Address myBgpId;
    private BgpRouteSelector bgpRouteSelector = new BgpRouteSelector(this);
    private ConcurrentMap<Ip4Prefix, BgpRouteEntry> bgpRoutes4 = new ConcurrentHashMap<Ip4Prefix, BgpRouteEntry>();
    private ConcurrentMap<Ip6Prefix, BgpRouteEntry> bgpRoutes6 = new ConcurrentHashMap<Ip6Prefix, BgpRouteEntry>();
    private static final int DEFAULT_BGP_PORT = 2000;
    private int bgpPort;

    @Activate
    protected void activate(ComponentContext context) {
        this.readComponentConfiguration(context);
        this.start();
        log.info("BgpSessionManager started");
    }

    @Deactivate
    protected void deactivate() {
        this.stop();
        log.info("BgpSessionManager stopped");
    }

    private void readComponentConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        try {
            String strPort = (String)properties.get("bgpPort");
            this.bgpPort = strPort != null ? Integer.parseInt(strPort) : 2000;
        }
        catch (ClassCastException | NumberFormatException e) {
            this.bgpPort = 2000;
        }
        log.debug("BGP port is set to {}", (Object)this.bgpPort);
    }

    @Modified
    public void modified(ComponentContext context) {
    }

    boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public Collection<BgpSession> getBgpSessions() {
        return this.bgpSessions.values();
    }

    @Override
    public Collection<BgpRouteEntry> getBgpRoutes4() {
        return this.bgpRoutes4.values();
    }

    @Override
    public Collection<BgpRouteEntry> getBgpRoutes6() {
        return this.bgpRoutes6.values();
    }

    BgpRouteEntry findBgpRoute(IpPrefix prefix) {
        if (prefix.isIp4()) {
            return (BgpRouteEntry)this.bgpRoutes4.get(prefix.getIp4Prefix());
        }
        return (BgpRouteEntry)this.bgpRoutes6.get(prefix.getIp6Prefix());
    }

    void addBgpRoute(BgpRouteEntry bgpRouteEntry) {
        if (bgpRouteEntry.isIp4()) {
            this.bgpRoutes4.put(bgpRouteEntry.prefix().getIp4Prefix(), bgpRouteEntry);
        } else {
            this.bgpRoutes6.put(bgpRouteEntry.prefix().getIp6Prefix(), bgpRouteEntry);
        }
    }

    boolean removeBgpRoute(IpPrefix prefix) {
        if (prefix.isIp4()) {
            return this.bgpRoutes4.remove(prefix.getIp4Prefix()) != null;
        }
        return this.bgpRoutes6.remove(prefix.getIp6Prefix()) != null;
    }

    void addSessionChannel(Channel channel) {
        this.allChannels.add((Object)channel);
    }

    void removeSessionChannel(Channel channel) {
        this.allChannels.remove((Object)channel);
    }

    boolean peerConnected(BgpSession bgpSession) {
        if (this.bgpSessions.get(bgpSession.remoteInfo().address()) != null) {
            return false;
        }
        this.bgpSessions.put(bgpSession.remoteInfo().address(), bgpSession);
        if (bgpSession.localInfo().address() instanceof InetSocketAddress) {
            InetAddress inetAddr = ((InetSocketAddress)bgpSession.localInfo().address()).getAddress();
            Ip4Address ip4Address = Ip4Address.valueOf((byte[])inetAddr.getAddress());
            this.updateMyBgpId(ip4Address);
        }
        return true;
    }

    void peerDisconnected(BgpSession bgpSession) {
        this.bgpSessions.remove(bgpSession.remoteInfo().address());
    }

    private synchronized void updateMyBgpId(Ip4Address ip4Address) {
        if (this.myBgpId == null) {
            this.myBgpId = ip4Address;
            log.debug("BGP: My BGP ID is {}", (Object)this.myBgpId);
        }
    }

    Ip4Address getMyBgpId() {
        return this.myBgpId;
    }

    BgpRouteSelector getBgpRouteSelector() {
        return this.bgpRouteSelector;
    }

    void update(Collection<Route> updates) {
        this.routeService.update(updates);
    }

    void withdraw(Collection<Route> withdraws) {
        this.routeService.withdraw(withdraws);
    }

    public void start() {
        log.debug("BGP Session Manager start.");
        this.isShutdown = false;
        NioServerSocketChannelFactory channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/bgp", (String)"sm-boss-%d", (Logger)log)), (Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/bgp", (String)"sm-worker-%d", (Logger)log)));
        ChannelPipelineFactory pipelineFactory = () -> {
            BgpSession bgpSessionHandler = new BgpSession(this);
            BgpFrameDecoder bgpFrameDecoder = new BgpFrameDecoder(bgpSessionHandler);
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("BgpFrameDecoder", (ChannelHandler)bgpFrameDecoder);
            pipeline.addLast("BgpSession", (ChannelHandler)bgpSessionHandler);
            return pipeline;
        };
        InetSocketAddress listenAddress = new InetSocketAddress(this.bgpPort);
        this.serverBootstrap = new ServerBootstrap((ChannelFactory)channelFactory);
        this.serverBootstrap.setOption("child.keepAlive", (Object)true);
        this.serverBootstrap.setOption("child.tcpNoDelay", (Object)true);
        this.serverBootstrap.setPipelineFactory(pipelineFactory);
        try {
            this.serverChannel = this.serverBootstrap.bind((SocketAddress)listenAddress);
            this.allChannels.add((Object)this.serverChannel);
        }
        catch (ChannelException e) {
            log.debug("Exception binding to BGP port {}: ", (Object)listenAddress.getPort(), (Object)e);
        }
    }

    public void stop() {
        this.isShutdown = true;
        this.allChannels.close().awaitUninterruptibly();
        this.serverBootstrap.releaseExternalResources();
    }

    protected void bindRouteService(RouteAdminService routeAdminService) {
        this.routeService = routeAdminService;
    }

    protected void unbindRouteService(RouteAdminService routeAdminService) {
        if (this.routeService == routeAdminService) {
            this.routeService = null;
        }
    }
}

