/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Objects;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.routing.bgp.BgpConstants;
import org.onosproject.routing.bgp.BgpSession;
import org.onosproject.routing.bgp.RouteEntry;

public class BgpRouteEntry
extends RouteEntry {
    private final BgpSession bgpSession;
    private final byte origin;
    private final AsPath asPath;
    private final long localPref;
    private long multiExitDisc = 0L;

    public BgpRouteEntry(BgpSession bgpSession, IpPrefix prefix, IpAddress nextHop, byte origin, AsPath asPath, long localPref) {
        super(prefix, nextHop);
        this.bgpSession = (BgpSession)((Object)Preconditions.checkNotNull((Object)((Object)bgpSession)));
        this.origin = origin;
        this.asPath = (AsPath)Preconditions.checkNotNull((Object)asPath);
        this.localPref = localPref;
    }

    public BgpSession getBgpSession() {
        return this.bgpSession;
    }

    public byte getOrigin() {
        return this.origin;
    }

    public AsPath getAsPath() {
        return this.asPath;
    }

    public long getLocalPref() {
        return this.localPref;
    }

    public long getMultiExitDisc() {
        return this.multiExitDisc;
    }

    void setMultiExitDisc(long multiExitDisc) {
        this.multiExitDisc = multiExitDisc;
    }

    boolean isLocalRoute() {
        PathSegment firstPathSegment = null;
        for (PathSegment pathSegment : this.asPath.getPathSegments()) {
            if (pathSegment.getType() != 1 && pathSegment.getType() != 2) continue;
            firstPathSegment = pathSegment;
            break;
        }
        if (firstPathSegment == null) {
            return true;
        }
        return firstPathSegment.getType() == 1;
    }

    long getNeighborAs() {
        PathSegment firstPathSegment = null;
        if (this.isLocalRoute()) {
            return 0L;
        }
        for (PathSegment pathSegment : this.asPath.getPathSegments()) {
            if (pathSegment.getType() != 1 && pathSegment.getType() != 2) continue;
            firstPathSegment = pathSegment;
            break;
        }
        if (firstPathSegment == null) {
            return 0L;
        }
        if (firstPathSegment.getSegmentAsNumbers().isEmpty()) {
            return 0L;
        }
        return firstPathSegment.getSegmentAsNumbers().get(0);
    }

    boolean hasAsPathLoop(long localAsNumber) {
        for (PathSegment pathSegment : this.asPath.getPathSegments()) {
            for (Long asNumber : pathSegment.getSegmentAsNumbers()) {
                if (!asNumber.equals(localAsNumber)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isBetterThan(BgpRouteEntry other) {
        Ip4Address otherPeerAddress;
        Ip4Address otherPeerBgpId;
        long thisNeighborAs;
        if (this == other) {
            return true;
        }
        if (this.getLocalPref() != other.getLocalPref()) {
            return this.getLocalPref() > other.getLocalPref();
        }
        if (this.getAsPath().getAsPathLength() != other.getAsPath().getAsPathLength()) {
            return this.getAsPath().getAsPathLength() < other.getAsPath().getAsPathLength();
        }
        if (this.getOrigin() != other.getOrigin()) {
            return this.getOrigin() < other.getOrigin();
        }
        if (!this.isLocalRoute() && !other.isLocalRoute() && (thisNeighborAs = this.getNeighborAs()) == other.getNeighborAs() && thisNeighborAs != 0L && this.getMultiExitDisc() != other.getMultiExitDisc()) {
            return this.getMultiExitDisc() > other.getMultiExitDisc();
        }
        Ip4Address peerBgpId = this.getBgpSession().remoteInfo().bgpId();
        if (!peerBgpId.equals((Object)(otherPeerBgpId = other.getBgpSession().remoteInfo().bgpId()))) {
            return peerBgpId.compareTo((IpAddress)otherPeerBgpId) < 0;
        }
        Ip4Address peerAddress = this.getBgpSession().remoteInfo().ip4Address();
        if (!peerAddress.equals((Object)(otherPeerAddress = other.getBgpSession().remoteInfo().ip4Address()))) {
            return peerAddress.compareTo((IpAddress)otherPeerAddress) < 0;
        }
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        BgpRouteEntry otherRoute = (BgpRouteEntry)other;
        return this.origin == otherRoute.origin && Objects.equals(this.asPath, otherRoute.asPath) && this.localPref == otherRoute.localPref && this.multiExitDisc == otherRoute.multiExitDisc;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("prefix", (Object)this.prefix()).add("nextHop", (Object)this.nextHop()).add("bgpId", (Object)this.bgpSession.remoteInfo().bgpId()).add("origin", (Object)BgpConstants.Update.Origin.typeToString(this.origin)).add("asPath", (Object)this.asPath).add("localPref", this.localPref).add("multiExitDisc", this.multiExitDisc).toString();
    }

    public static class AsPath {
        private final ArrayList<PathSegment> pathSegments;
        private final int asPathLength;

        AsPath(ArrayList<PathSegment> pathSegments) {
            this.pathSegments = (ArrayList)Preconditions.checkNotNull(pathSegments);
            int pl = 0;
            for (PathSegment pathSegment : pathSegments) {
                switch (pathSegment.getType()) {
                    case 1: {
                        ++pl;
                        break;
                    }
                    case 2: {
                        pl += pathSegment.getSegmentAsNumbers().size();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
            }
            this.asPathLength = pl;
        }

        public ArrayList<PathSegment> getPathSegments() {
            return this.pathSegments;
        }

        int getAsPathLength() {
            return this.asPathLength;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AsPath)) {
                return false;
            }
            AsPath otherAsPath = (AsPath)other;
            return Objects.equals(this.pathSegments, otherAsPath.pathSegments);
        }

        public int hashCode() {
            return this.pathSegments.hashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("pathSegments", this.pathSegments).toString();
        }
    }

    public static class PathSegment {
        private final byte type;
        private final ArrayList<Long> segmentAsNumbers;

        PathSegment(byte type, ArrayList<Long> segmentAsNumbers) {
            this.type = type;
            this.segmentAsNumbers = (ArrayList)Preconditions.checkNotNull(segmentAsNumbers);
        }

        public byte getType() {
            return this.type;
        }

        public ArrayList<Long> getSegmentAsNumbers() {
            return this.segmentAsNumbers;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathSegment)) {
                return false;
            }
            PathSegment otherPathSegment = (PathSegment)other;
            return Objects.equals(this.type, otherPathSegment.type) && Objects.equals(this.segmentAsNumbers, otherPathSegment.segmentAsNumbers);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.segmentAsNumbers);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("type", (Object)BgpConstants.Update.AsPath.typeToString(this.type)).add("segmentAsNumbers", this.segmentAsNumbers).toString();
        }
    }
}

