/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.bgp;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.onosproject.routing.bgp.BgpKeepalive;
import org.onosproject.routing.bgp.BgpNotification;
import org.onosproject.routing.bgp.BgpOpen;
import org.onosproject.routing.bgp.BgpSession;
import org.onosproject.routing.bgp.BgpUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BgpFrameDecoder
extends FrameDecoder {
    private static final Logger log = LoggerFactory.getLogger(BgpFrameDecoder.class);
    private final BgpSession bgpSession;

    BgpFrameDecoder(BgpSession bgpSession) {
        this.bgpSession = bgpSession;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buf) throws Exception {
        if (this.bgpSession.isClosed()) {
            return null;
        }
        log.trace("BGP Peer: decode(): remoteAddr = {} localAddr = {} messageSize = {}", new Object[]{ctx.getChannel().getRemoteAddress(), ctx.getChannel().getLocalAddress(), buf.readableBytes()});
        if (buf.readableBytes() < 19) {
            return null;
        }
        buf.markReaderIndex();
        byte[] marker = new byte[16];
        buf.readBytes(marker);
        for (int i = 0; i < marker.length; ++i) {
            if (marker[i] == -1) continue;
            log.debug("BGP RX Error: invalid marker {} at position {}", (Object)marker[i], (Object)i);
            int errorCode = 1;
            int errorSubcode = 1;
            ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, null);
            ctx.getChannel().write((Object)txMessage);
            this.bgpSession.closeSession(ctx);
            return null;
        }
        int length = buf.readUnsignedShort();
        if (length < 19 || length > 4096) {
            log.debug("BGP RX Error: invalid Length field {}. Must be between {} and {}", new Object[]{length, 19, 4096});
            ChannelBuffer txMessage = BgpNotification.prepareBgpNotificationBadMessageLength(length);
            ctx.getChannel().write((Object)txMessage);
            this.bgpSession.closeSession(ctx);
            return null;
        }
        int remainingMessageLen = length - 16 - 2;
        if (buf.readableBytes() < remainingMessageLen) {
            buf.resetReaderIndex();
            return null;
        }
        short type = buf.readUnsignedByte();
        ChannelBuffer message = buf.readBytes(--remainingMessageLen);
        switch (type) {
            case 1: {
                BgpOpen.processBgpOpen(this.bgpSession, ctx, message);
                break;
            }
            case 2: {
                BgpUpdate.processBgpUpdate(this.bgpSession, ctx, message);
                break;
            }
            case 3: {
                BgpNotification.processBgpNotification(this.bgpSession, ctx, message);
                break;
            }
            case 4: {
                BgpKeepalive.processBgpKeepalive(this.bgpSession, ctx, message);
                break;
            }
            default: {
                int errorCode = 1;
                int errorSubcode = 3;
                ChannelBuffer data = ChannelBuffers.buffer((int)1);
                data.writeByte((int)type);
                ChannelBuffer txMessage = BgpNotification.prepareBgpNotification(errorCode, errorSubcode, data);
                ctx.getChannel().write((Object)txMessage);
                this.bgpSession.closeSession(ctx);
                return null;
            }
        }
        return null;
    }
}

