/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.event;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.event.VirtualEvent;

public final class VirtualListenerRegistryManager
implements EventSink<VirtualEvent> {
    private Map<NetworkId, Map<Class<? extends Event>, ListenerRegistry>> listenerMapByNetwork = Maps.newConcurrentMap();
    ListenerRegistry lastStart;

    private VirtualListenerRegistryManager() {
    }

    public static VirtualListenerRegistryManager getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public ListenerRegistry getRegistry(NetworkId networkId, Class<? extends Event> eventClass) {
        ListenerRegistry listenerRegistry;
        ConcurrentMap listenerMapByEvent = this.listenerMapByNetwork.get((Object)networkId);
        if (listenerMapByEvent == null) {
            listenerMapByEvent = Maps.newConcurrentMap();
            this.listenerMapByNetwork.putIfAbsent(networkId, listenerMapByEvent);
        }
        if ((listenerRegistry = (ListenerRegistry)listenerMapByEvent.get(eventClass)) == null) {
            listenerRegistry = new ListenerRegistry();
            listenerMapByEvent.putIfAbsent(eventClass, listenerRegistry);
        }
        return listenerRegistry;
    }

    public void process(VirtualEvent event) {
        NetworkId networkId = event.networkId();
        Event originalEvent = (Event)event.subject();
        ListenerRegistry listenerRegistry = this.listenerMapByNetwork.get((Object)networkId).get(originalEvent.getClass());
        if (listenerRegistry != null) {
            listenerRegistry.process(originalEvent);
            this.lastStart = listenerRegistry;
        }
    }

    public void onProcessLimit() {
        this.lastStart.onProcessLimit();
    }

    private static final class SingletonHelper {
        private static final String ILLEGAL_ACCESS_MSG = "Should not instantiate this class.";
        private static final VirtualListenerRegistryManager INSTANCE = new VirtualListenerRegistryManager();

        private SingletonHelper() {
            throw new IllegalAccessError(ILLEGAL_ACCESS_MSG);
        }
    }
}

