/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.event;

import org.onlab.osgi.ServiceDirectory;
import org.onosproject.event.Event;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventListener;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.event.ListenerService;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.VnetService;
import org.onosproject.incubator.net.virtual.event.VirtualEvent;
import org.onosproject.incubator.net.virtual.event.VirtualListenerRegistryManager;

public abstract class AbstractVirtualListenerManager<E extends Event, L extends EventListener<E>>
implements ListenerService<E, L>,
VnetService {
    protected final NetworkId networkId;
    protected final VirtualNetworkService manager;
    protected final ServiceDirectory serviceDirectory;
    protected EventDeliveryService eventDispatcher;
    private ListenerRegistry<E, L> listenerRegistry;
    private VirtualListenerRegistryManager listenerManager = VirtualListenerRegistryManager.getInstance();

    public AbstractVirtualListenerManager(VirtualNetworkService manager, NetworkId networkId, Class<? extends Event> eventClass) {
        this.manager = manager;
        this.networkId = networkId;
        this.serviceDirectory = manager.getServiceDirectory();
        this.eventDispatcher = (EventDeliveryService)this.serviceDirectory.get(EventDeliveryService.class);
        this.listenerRegistry = this.listenerManager.getRegistry(networkId, eventClass);
    }

    public void addListener(L listener) {
        this.listenerRegistry.addListener(listener);
    }

    public void removeListener(L listener) {
        this.listenerRegistry.removeListener(listener);
    }

    protected void post(E event) {
        if (event != null && this.eventDispatcher != null) {
            VirtualEvent<E> vEvent = new VirtualEvent<E>(this.networkId, VirtualEvent.Type.POSTED, event);
            this.eventDispatcher.post(vEvent);
        }
    }

    @Override
    public NetworkId networkId() {
        return this.networkId;
    }
}

