/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;

@Beta
public final class VirtualNetworkIntent
extends ConnectivityIntent {
    private final NetworkId networkId;
    private final ConnectPoint ingressPoint;
    private final ConnectPoint egressPoint;
    private static final String NETWORK_ID_NULL = "Network ID cannot be null";

    public static Builder builder() {
        return new Builder();
    }

    private VirtualNetworkIntent(NetworkId networkId, ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, ConnectPoint ingressPoint, ConnectPoint egressPoint, List<Constraint> constraints, int priority, ResourceGroup resourceGroup) {
        super(appId, key, Collections.emptyList(), selector, treatment, constraints, priority, resourceGroup);
        Preconditions.checkNotNull((Object)((Object)networkId), (Object)NETWORK_ID_NULL);
        Preconditions.checkArgument((!ingressPoint.equals((Object)egressPoint) ? 1 : 0) != 0, (String)"ingress and egress should be different (ingress: %s, egress: %s)", (Object)ingressPoint, (Object)egressPoint);
        this.networkId = networkId;
        this.ingressPoint = (ConnectPoint)Preconditions.checkNotNull((Object)ingressPoint);
        this.egressPoint = (ConnectPoint)Preconditions.checkNotNull((Object)egressPoint);
    }

    protected VirtualNetworkIntent() {
        this.networkId = null;
        this.ingressPoint = null;
        this.egressPoint = null;
    }

    public NetworkId networkId() {
        return this.networkId;
    }

    public ConnectPoint ingressPoint() {
        return this.ingressPoint;
    }

    public ConnectPoint egressPoint() {
        return this.egressPoint;
    }

    public String toString() {
        return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("networkId", (Object)this.networkId).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", (Object)this.resources()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("ingress", (Object)this.ingressPoint).add("egress", (Object)this.egressPoint).add("constraints", (Object)this.constraints()).add("resourceGroup", (Object)this.resourceGroup()).toString();
    }

    public static final class Builder
    extends ConnectivityIntent.Builder {
        NetworkId networkId;
        ConnectPoint ingressPoint;
        ConnectPoint egressPoint;

        private Builder() {
        }

        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        public Builder resourceGroup(ResourceGroup resourceGroup) {
            return (Builder)super.resourceGroup(resourceGroup);
        }

        public Builder networkId(NetworkId networkId) {
            this.networkId = networkId;
            return this;
        }

        public Builder ingressPoint(ConnectPoint ingressPoint) {
            this.ingressPoint = ingressPoint;
            return this;
        }

        public Builder egressPoint(ConnectPoint egressPoint) {
            this.egressPoint = egressPoint;
            return this;
        }

        public VirtualNetworkIntent build() {
            return new VirtualNetworkIntent(this.networkId, this.appId, this.key, this.selector, this.treatment, this.ingressPoint, this.egressPoint, this.constraints, this.priority, this.resourceGroup);
        }
    }
}

