/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualLink;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.Link;
import org.onosproject.net.provider.ProviderId;

public final class DefaultVirtualLink
extends DefaultLink
implements VirtualLink {
    private static final String VIRTUAL = "virtualLink";
    public static final ProviderId PID = new ProviderId("virtualLink", "virtualLink");
    private final NetworkId networkId;
    private final TunnelId tunnelId;

    private DefaultVirtualLink(NetworkId networkId, ConnectPoint src, ConnectPoint dst, Link.State state, TunnelId tunnelId) {
        super(PID, src, dst, Link.Type.VIRTUAL, state, new Annotations[]{DefaultAnnotations.builder().build()});
        this.networkId = networkId;
        this.tunnelId = tunnelId;
    }

    @Override
    public NetworkId networkId() {
        return this.networkId;
    }

    @Override
    public TunnelId tunnelId() {
        return this.tunnelId;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.networkId, this.tunnelId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultVirtualLink) {
            DefaultVirtualLink that = (DefaultVirtualLink)obj;
            return super.equals((Object)that) && Objects.equals((Object)this.networkId, (Object)that.networkId) && Objects.equals((Object)this.tunnelId, (Object)that.tunnelId);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("networkId", (Object)this.networkId).add("tunnelId", (Object)this.tunnelId).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends DefaultLink.Builder {
        private NetworkId networkId;
        private ConnectPoint src;
        private ConnectPoint dst;
        private TunnelId tunnelId;
        private Link.State state;

        private Builder() {
        }

        public Builder networkId(NetworkId networkId) {
            this.networkId = networkId;
            return this;
        }

        public Builder src(ConnectPoint src) {
            this.src = src;
            return this;
        }

        public Builder dst(ConnectPoint dst) {
            this.dst = dst;
            return this;
        }

        public Builder tunnelId(TunnelId tunnelId) {
            this.tunnelId = tunnelId;
            return this;
        }

        public Builder state(Link.State state) {
            this.state = state;
            return this;
        }

        public DefaultVirtualLink build() {
            Preconditions.checkNotNull((Object)this.src, (Object)"Source connect point cannot be null");
            Preconditions.checkNotNull((Object)this.dst, (Object)"Destination connect point cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.networkId), (Object)"Network Id cannot be null");
            return new DefaultVirtualLink(this.networkId, this.src, this.dst, this.state, this.tunnelId);
        }
    }
}

