/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.tunnel;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.net.AbstractAnnotated;
import org.onosproject.net.Annotations;

@Beta
public final class TunnelSubscription
extends AbstractAnnotated {
    private final ApplicationId consumerId;
    private final TunnelEndPoint src;
    private final TunnelEndPoint dst;
    private final Tunnel.Type type;
    private final TunnelId tunnelId;
    private final TunnelName tunnelName;

    public TunnelSubscription(ApplicationId consumerId, TunnelEndPoint src, TunnelEndPoint dst, TunnelId tunnelId, Tunnel.Type type, TunnelName tunnelName, Annotations ... annotations) {
        super(annotations);
        Preconditions.checkNotNull((Object)consumerId, (Object)"consumerId cannot be null");
        this.consumerId = consumerId;
        this.src = src;
        this.dst = dst;
        this.type = type;
        this.tunnelId = tunnelId;
        this.tunnelName = tunnelName;
    }

    public ApplicationId consumerId() {
        return this.consumerId;
    }

    public TunnelEndPoint src() {
        return this.src;
    }

    public TunnelEndPoint dst() {
        return this.dst;
    }

    public Tunnel.Type type() {
        return this.type;
    }

    public TunnelId tunnelId() {
        return this.tunnelId;
    }

    public TunnelName tunnelName() {
        return this.tunnelName;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.consumerId, this.src, this.dst, this.type, this.tunnelId, this.tunnelName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TunnelSubscription) {
            TunnelSubscription other = (TunnelSubscription)((Object)obj);
            return Objects.equals(this.src, other.src) && Objects.equals(this.dst, other.dst) && Objects.equals(this.consumerId, other.consumerId) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.tunnelId, (Object)other.tunnelId) && Objects.equals(this.tunnelName, other.tunnelName);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("src", (Object)this.src).add("dst", (Object)this.dst).add("consumerId", (Object)this.consumerId).add("type", (Object)this.type).add("tunnelId", (Object)this.tunnelId).add("tunnelName", (Object)this.tunnelName).toString();
    }
}

