/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.tunnel;

import com.google.common.annotations.Beta;
import java.time.Duration;
import java.util.List;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelStatistics;

@Beta
public final class DefaultTunnelStatistics
implements TunnelStatistics {
    private final TunnelId tunnelId;
    private final double bwUtilization;
    private final double packetLossRatio;
    private final Duration flowDelay;
    private final List<String> alarms;

    private DefaultTunnelStatistics(TunnelId tunnelId, double bwUtilization, double packetLossRatio, Duration flowDelay, List<String> alarms) {
        this.tunnelId = tunnelId;
        this.bwUtilization = bwUtilization;
        this.packetLossRatio = packetLossRatio;
        this.flowDelay = flowDelay;
        this.alarms = alarms;
    }

    private DefaultTunnelStatistics() {
        this.tunnelId = null;
        this.bwUtilization = 0.0;
        this.packetLossRatio = 0.0;
        this.flowDelay = null;
        this.alarms = null;
    }

    @Override
    public TunnelId id() {
        return this.tunnelId;
    }

    @Override
    public double bandwidthUtilization() {
        return this.bwUtilization;
    }

    @Override
    public double packetLossRate() {
        return this.packetLossRatio;
    }

    @Override
    public Duration flowDelay() {
        return this.flowDelay;
    }

    @Override
    public List<String> alarms() {
        return this.alarms;
    }

    public static final class Builder {
        TunnelId tunnelId;
        double bwUtilization;
        double packetLossRatio;
        Duration flowDelay;
        List<String> alarms;

        public Builder setTunnelId(TunnelId tunnelId) {
            this.tunnelId = tunnelId;
            return this;
        }

        public Builder setBwUtilization(double bwUtilization) {
            this.bwUtilization = bwUtilization;
            return this;
        }

        public Builder setPacketLossRatio(double packetLossRatio) {
            this.packetLossRatio = packetLossRatio;
            return this;
        }

        public Builder setFlowDelay(Duration flowDelay) {
            this.flowDelay = flowDelay;
            return this;
        }

        public Builder setAlarms(List<String> alarms) {
            this.alarms = alarms;
            return this;
        }

        public DefaultTunnelStatistics build() {
            return new DefaultTunnelStatistics(this.tunnelId, this.bwUtilization, this.packetLossRatio, this.flowDelay, this.alarms);
        }
    }
}

