/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.tunnel;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.core.GroupId;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.net.AbstractModel;
import org.onosproject.net.Annotations;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.Path;
import org.onosproject.net.provider.ProviderId;

@Beta
public final class DefaultTunnel
extends AbstractModel
implements Tunnel {
    private final TunnelEndPoint src;
    private final TunnelEndPoint dst;
    private final Tunnel.State state;
    private final Tunnel.Type type;
    private final GroupId groupId;
    private final TunnelId tunnelId;
    private final TunnelName tunnelName;
    private final Path path;
    private final NetworkResource networkRes;

    public DefaultTunnel(ProviderId producerName, TunnelEndPoint src, TunnelEndPoint dst, Tunnel.Type type, GroupId groupId, TunnelId tunnelId, TunnelName tunnelName, Path path, Annotations ... annotations) {
        this(producerName, src, dst, type, Tunnel.State.ACTIVE, groupId, tunnelId, tunnelName, path, annotations);
    }

    public DefaultTunnel(ProviderId producerName, TunnelEndPoint src, TunnelEndPoint dst, Tunnel.Type type, Tunnel.State state, GroupId groupId, TunnelId tunnelId, TunnelName tunnelName, Path path, Annotations ... annotations) {
        super(producerName, annotations);
        this.src = src;
        this.dst = dst;
        this.type = type;
        this.state = state;
        this.groupId = groupId;
        this.tunnelId = tunnelId;
        this.tunnelName = tunnelName;
        this.path = path;
        this.networkRes = null;
    }

    public DefaultTunnel(ProviderId producerName, TunnelEndPoint src, TunnelEndPoint dst, Tunnel.Type type, GroupId groupId, TunnelId tunnelId, TunnelName tunnelName, Path path, NetworkResource networkRes, Annotations ... annotations) {
        this(producerName, src, dst, type, Tunnel.State.ACTIVE, groupId, tunnelId, tunnelName, path, networkRes, annotations);
    }

    public DefaultTunnel(ProviderId producerName, TunnelEndPoint src, TunnelEndPoint dst, Tunnel.Type type, Tunnel.State state, GroupId groupId, TunnelId tunnelId, TunnelName tunnelName, Path path, NetworkResource networkRes, Annotations ... annotations) {
        super(producerName, annotations);
        this.src = src;
        this.dst = dst;
        this.type = type;
        this.state = state;
        this.groupId = groupId;
        this.tunnelId = tunnelId;
        this.tunnelName = tunnelName;
        this.path = path;
        this.networkRes = networkRes;
    }

    @Override
    public TunnelEndPoint src() {
        return this.src;
    }

    @Override
    public TunnelEndPoint dst() {
        return this.dst;
    }

    @Override
    public Tunnel.Type type() {
        return this.type;
    }

    @Override
    public Tunnel.State state() {
        return this.state;
    }

    @Override
    public NetworkResource resource() {
        return this.networkRes;
    }

    @Override
    public TunnelId tunnelId() {
        return this.tunnelId;
    }

    @Override
    public GroupId groupId() {
        return this.groupId;
    }

    @Override
    public TunnelName tunnelName() {
        return this.tunnelName;
    }

    @Override
    public Path path() {
        return this.path;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.src, this.dst, this.type, this.groupId, this.tunnelId, this.tunnelName, this.state, this.path, this.networkRes});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTunnel) {
            DefaultTunnel other = (DefaultTunnel)obj;
            return Objects.equals(this.src, other.src) && Objects.equals(this.dst, other.dst) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.groupId, other.groupId) && Objects.equals((Object)this.tunnelId, (Object)other.tunnelId) && Objects.equals(this.tunnelName, other.tunnelName) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.path, other.path) && Objects.equals(this.networkRes, other.networkRes);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("src", (Object)this.src).add("dst", (Object)this.dst).add("type", (Object)this.type).add("state", (Object)this.state).add("groupId", (Object)this.groupId).add("producerTunnelId", (Object)this.tunnelId).add("tunnelName", (Object)this.tunnelName).add("path", (Object)this.path).add("networkResource", (Object)this.networkRes).toString();
    }
}

