/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.routing;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.net.config.Config;

public class RouteConfig
extends Config<ApplicationId> {
    private static final String PREFIX = "prefix";
    private static final String NEXTHOP = "nextHop";

    public Set<Route> getRoutes() {
        ImmutableSet.Builder routes = ImmutableSet.builder();
        this.array.forEach(route -> {
            try {
                IpPrefix prefix = IpPrefix.valueOf((String)route.path(PREFIX).asText());
                IpAddress nextHop = IpAddress.valueOf((String)route.path(NEXTHOP).asText());
                routes.add((Object)new Route(Route.Source.STATIC, prefix, nextHop));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        return routes.build();
    }

    public boolean isValid() {
        this.array.forEach(routeNode -> {
            if (!routeNode.isObject()) {
                throw new IllegalArgumentException("Not object node");
            }
            ObjectNode route = (ObjectNode)routeNode;
            this.isIpPrefix(route, PREFIX, Config.FieldPresence.MANDATORY);
            this.isIpAddress(route, NEXTHOP, Config.FieldPresence.MANDATORY);
        });
        return true;
    }
}

